
(in-package "CL-USER")

; for an explination of how this works, see "Clause Form Conversions
; for Boolean Circuits" by Jackson and Sheridan.

(defvar *zchaff* "zchaff")
(defvar *siege*  "siege_v4")
(defvar *minisat* "minisat")
(defvar *satelite* "SatELite_v1.0_macOS")
(defvar *counter* 0)
(defvar *order-val* 0)
(defvar *sforms* t)
(defvar *sp* t)
(defvar *cnf* 'mv)
(defvar *df* nil)
(defvar *if* t)
;;(defvar *pol* t)
(defvar *lp* nil)

(defvar *pf-sharingp* nil) ;; whether sharing analysis should be "polarity-free".

;; whether to actually try performing disjunctions with and without
;; introducing vars and choose the best
(defvar *tryp* nil) 


(defvar *var-policy* 'lits) ;; should be one of 'clauses 'lits or 'all
(defvar *or-parp* nil) ;; whether to introduce a variable only if some parent is an or
(defvar *metap* t) ;; whether to use meta nodes
(defvar *mergingp* nil)
(defvar *matchingp* nil)

(defun reset-to-defaults ()
  (setf *pf-sharingp* nil) 
  (setf *tryp* nil) 
  (setf *var-policy* 'lits)
  (setf *or-parp* nil)
  (setf *metap* t)
  (setf *mergingp* nil)
  (setf *matchingp* nil))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; counting shares                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; (declaim (ftype (function (t boolean) null) label-shares+))
;; (defun label-shares+ (form or-parentp)
;;   (when (formula-p form)
;;     (if (eq (formula-fn form) 'not)
;; 	(label-shares- (first (formula-args form)) or-parentp)
;;       (let ((slot (formula-slot1 form)))
;; 	(when (and or-parentp
;; 		   (not (cdr slot)))
;; 	  (setf (cdr slot) t))
;; 	(case (car slot)
;; 	  (dna (setf (car slot) 'noshare)
;; 	       (if (eq (formula-fn form) 'meta)
;; 		   (label-shares+ (first (formula-args form)) nil)
;; 		 (loop for arg in (formula-args form)
;; 		       do (label-shares+ arg nil))))
;; 	  (noshare (setf (car slot) 'share))))))
;;   nil)


;; (declaim (ftype (function (t boolean) null) label-shares+))
;; (defun label-shares- (form or-parentp)
;;   (when (formula-p form)
;;     (if (eq (formula-fn form) 'not)
;; 	(label-shares+ (first (formula-args form)) or-parentp)
;;       (let ((slot (formula-slot2 form)))
;; 	(when (and or-parentp
;; 		   (not (cdr slot)))
;; 	  (setf (cdr slot) t))
;; 	(case (car slot)
;; 	  (dna (setf (car slot) 'noshare)
;; 	       (if (eq (formula-fn form) 'meta)
;; 		   (label-shares- (second (formula-args form)) nil)
;; 		 (loop for arg in (formula-args form)
;; 		       do (label-shares- arg
;; 					 (eq (formula-fn form)
;; 					     'and)))))
;; 	  (noshare (setf (car slot) 'share))))))
;;   nil)


(declaim (ftype (function (t boolean) null) label-shares+))
(defun label-shares+ (form or-parentp)
  (when (formula-p form)
    (if (eq (formula-fn form) 'not)
	(label-shares- (first (formula-args form)) or-parentp)
      (let ((slot1 (formula-slot1 form))
	    (slot2 (formula-slot2 form)))
	(when (eq (car slot1) 'dna)
	  (if (eq (formula-fn form) 'meta)
	      (label-shares+ (first (formula-args form)) nil)
	    (loop for arg in (formula-args form)
		  do (label-shares+ arg nil))))
	(cond ((or (not *pf-sharingp*)
		   (eq (car slot2) 'dna))
	       (when (and or-parentp
			  (not (cdr slot1)))
		 (setf (cdr slot1) t))
	       (case (car slot1)
		 (dna (setf (car slot1) 'noshare))
		 (noshare (setf (car slot1) 'share))))
	      (t
	       (when (or or-parentp (cdr slot1) (cdr slot2))
		 (unless (cdr slot1) (setf (cdr slot1) t))
		 (unless (cdr slot2) (setf (cdr slot2) t)))
	       (unless (eq (car slot1) 'share) (setf (car slot1) 'share))
	       (unless (eq (car slot2) 'share) (setf (car slot2) 'share)))))))
  nil)

(declaim (ftype (function (t boolean) null) label-shares+))
(defun label-shares- (form or-parentp)
  (when (formula-p form)
    (if (eq (formula-fn form) 'not)
	(label-shares+ (first (formula-args form)) or-parentp)
      (let ((slot1 (formula-slot1 form))
	    (slot2 (formula-slot2 form)))
	(when (eq (car slot2) 'dna)
	  (if (eq (formula-fn form) 'meta)
	      (label-shares- (second (formula-args form)) nil)
	    (loop for arg in (formula-args form)
		  do (label-shares- arg nil))))
	(cond ((or (not *pf-sharingp*)
		   (eq (car slot1) 'dna))
	       (when (and or-parentp
			  (not (cdr slot2)))
		 (setf (cdr slot2) t))
	       (case (car slot2)
		 (dna (setf (car slot2) 'noshare))
		 (noshare (setf (car slot2) 'share))))
	      (t	  
	       (when (or or-parentp (cdr slot2) (cdr slot1))
		 (unless (cdr slot2) (setf (cdr slot2) t))
		 (unless (cdr slot1) (setf (cdr slot1) t)))
	       (unless (eq (car slot2) 'share) (setf (car slot2) 'share))
	       (unless (eq (car slot1) 'share) (setf (car slot1) 'share)))))))
  nil)


;;   (when (formula-p form)
;;     (when (and (or or-parentp
;; 		   (and *pf-sharingp*
;; 			(eq (car (formula-slot1 form)) 'dna)
;; 			(cdr (formula-slot2 form))))
;; 	       (not (cdr (formula-slot1 form))))
;;       (setf (cdr (formula-slot1 form)) t)
;;       (when (and *pf-sharingp*
;; 		 (not (cdr (formula-slot2 form)))
;; 		 (not (eq (car (formula-slot2 form)) 'dna)))
;; 	(setf (cdr (formula-slot2 form)) t)))
;;     (cond ((eq (formula-fn form) 'not)
;; 	   (label-shares- (first (formula-args form))
;; 			  or-parentp))
;; 	  ((not (eq (car (formula-slot1 form)) 'share))
;; 	   (when (eq (car (formula-slot1 form)) 'dna)
;; 	     (dolist (arg (formula-args form))
;; 	       (label-shares+ arg nil)))
;; 	   (when (and *pf-sharingp* (eq (car (formula-slot2 form)) 'noshare))
;; 	     (setf (car (formula-slot2 form)) 'share))
;; 	   (if (or (and *pf-sharingp*
;; 			(not (eq (car (formula-slot2 form)) 'dna)))
;; 		   (eq (car (formula-slot1 form)) 'noshare))
;; 	       (setf (car (formula-slot1 form)) 'share)
;; 	     (setf (car (formula-slot1 form)) 'noshare)))))
;;   nil)




;; (declaim (ftype (function (t boolean) null) label-shares-))
;; (defun label-shares- (form or-parentp)
;;   (when (formula-p form)
;;     (when (and (or or-parentp
;; 		   (and *pf-sharingp*
;; 			(eq (car (formula-slot2 form)) 'dna)
;; 			(cdr (formula-slot1 form))))
;; 	       (not (cdr (formula-slot2 form))))
;;       (setf (cdr (formula-slot2 form)) t)
;;       (when (and *pf-sharingp*
;; 		 (not (cdr (formula-slot1 form)))
;; 		 (not (eq (car (formula-slot1 form)) 'dna)))
;; 	(setf (cdr (formula-slot1 form)) t)))
;;     (cond ((eq (formula-fn form) 'not)
;; 	   (label-shares+ (first (formula-args form))
;; 			  or-parentp))
;; 	  ((not (eq (car (formula-slot2 form)) 'share))
;; 	   (when (eq (car (formula-slot2 form)) 'dna)
;; 	     (dolist (arg (formula-args form))
;; 	       (label-shares- arg (eq (formula-fn form) 'and))))
;; 	   (when (and *pf-sharingp* (eq (car (formula-slot1 form)) 'noshare))
;; 	     (setf (car (formula-slot1 form)) 'share))
;; 	   (if (or (and *pf-sharingp*
;; 			(not (eq (car (formula-slot1 form)) 'dna)))
;; 		   (eq (car (formula-slot2 form)) 'noshare))
;; 	       (setf (car (formula-slot2 form)) 'share)
;; 	     (setf (car (formula-slot2 form)) 'noshare)))))
;;   nil)

(defun label-shares-aux (form)
  (when (and (formula-p form)
	     (not (formula-slot1 form)))
    (setf (formula-slot1 form) (cons 'dna nil))
    (setf (formula-slot2 form) (cons 'dna nil))
    (dolist (arg (formula-args form))
      (label-shares-aux arg))))

(declaim (ftype (function (t) null) label-shares))
(defun label-shares (form)
  (label-shares-aux form)
  (label-shares+ form nil))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; adding redundant constraints for ifs       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun add-redundancies-aux (form acc)
  (cond ((not (formula-p form)) acc)
	((formula-slot1 form) acc)
	(t
	 (setf (formula-slot1 form) t)
	 (let ((acc acc))
	   (dolist (arg (formula-args form))
	     (setf acc (add-redundancies-aux arg acc)))
	   (if (eq (formula-fn form) 'if)
	       (let ((arg2 (second (formula-args form)))
		     (arg3 (third (formula-args form))))
		 (cons (sb-or-form (list (sb-not-form arg2)
					 (sb-not-form arg3)
					 form))
		       (cons (sb-or-form (list arg2 arg3 (sb-not-form form)))
			     acc)))
	     acc)))))

(defun add-redundancies (form)
  (let ((ar (add-redundancies-aux form nil)))
    (clear-slot1 form)
    (sb-and-form (cons form ar))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; new clause representation                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;(defvar *empty-cnf-lit* (make-cnf-lit))


(defstruct (cnf-var (:print-function print-cnf-var))
  (order-val 0 :type fixnum)
  (intermediatep nil :type boolean)
  (num 0 :type fixnum)
  (form *junk* :type formula)
  (lit+ nil :type (or null cnf-lit))
  (lit- nil :type (or null cnf-lit)))

(defun print-cnf-var (s stream depth)
  (declare (ignore depth))
  (let ((pval `(cnf-var :order-val ,(cnf-var-order-val s)
			:intermediatep ,(cnf-var-intermediatep s)
			:num ,(cnf-var-num s)
			:form ,(formula-value (cnf-var-form s)))))
  (format stream "~A" pval)))

(defvar *empty-cnf-var* (make-cnf-var))

(defstruct (cnf-lit (:print-function print-cnf-lit))
  (var *empty-cnf-var* :type cnf-var)
  (implies t :type (or boolean clause-list))
  (appears nil :type boolean)
  (pol t :type boolean))


(defun print-cnf-lit (s stream depth)
  (declare (ignore depth))
  (let ((pval `(cnf-lit :var ,(cnf-lit-var s)
			:appears ,(cnf-lit-appears s)
			;;:implies ,(cnf-lit-implies s)
			:pol ,(cnf-lit-pol s))))
  (format stream "~A" pval)))

(defstruct clause
  (len 1 :type fixnum)
  (ltree 0 :type (or cnf-lit cons))
  (flattened nil :type list))

(defstruct clause-list
  (cl-num 0 :type fixnum)
  (lit-num 0 :type fixnum)
  (max-cl-len 0 :type fixnum)
  (clauses nil :type list))

;; trees
(defun single-lit-clausesp (clauses)
  (and (clause-list-p clauses)
       (= (clause-list-cl-num clauses) 1)
       (= (clause-list-max-cl-len clauses) 1)))

;; ;; trees
;; (defun single-lit-clausesp (clauses)
;;   (and (consp clauses)
;;        (endp (rest clauses))
;;        (clause-p (first clauses))
;;        (atom (clause-ltree (first clauses)))))

(defun slc-get-lit (clauses)
  (let ((ltree (clause-ltree (first (clause-list-clauses clauses)))))
    (if *mergingp*
	(first ltree)
      ltree)))
	    

(defun clause-for-lit (lit)
  (make-clause :ltree (if *mergingp* (list lit) lit)))

;; ;; lists
;; (defun single-lit-clausesp (clauses)
;;   (and (consp clauses)
;;        (endp (rest clauses))
;;        (clause-p (first clauses))
;;        (endp (cdr (clause-ltree (first clauses))))))

;; (defmacro slc-get-lit (clauses)
;;   `(first (clause-ltree (first ,clauses))))
	    

;; (defun clause-for-lit (lit)
;;   (make-clause :ltree `(,lit)))


(defun clauses-for-lit (lit)
  (make-clause-list :cl-num 1
		    :lit-num 1
		    :max-cl-len 1
		    :clauses `(,(clause-for-lit lit))))

;; (defmacro clauses-for-lit (lit)
;;   `(list (clause-for-lit ,lit)))

;; ;; lists
;; (defun merge-clauses (c1 c2)
;;   (cond ((or (eq c1 t) (eq c2 t)) t)
;; 	((eq c1 nil) c2)
;; 	((eq c2 nil) c1)
;; 	((< (clause-len c1) (clause-len c2))
;; 	 (make-clause :len (+ (clause-len c1) (clause-len c2))
;; 		      :ltree (append (clause-ltree c1)
;; 				     (clause-ltree c2))))
;; 	(t
;; 	 (make-clause :len (+ (clause-len c1) (clause-len c2))
;; 		      :ltree (append (clause-ltree c2)
;; 				     (clause-ltree c1))))))

(defun lit-listp (list)
  (or (endp list)
      (and (cnf-lit-p (car list))
	   (lit-listp (cdr list)))))
    

(defun merge-ltrees (lt1 lt2)
  (cond ((endp lt1)
	 (values lt2 (list-length lt2)))
	((endp lt2)
	 (values lt1 (list-length lt1)))
	((eq (cnf-lit-var (car lt1))
	     (cnf-lit-var (car lt2)))
	 (if (eq (cnf-lit-pol (car lt1))
		 (cnf-lit-pol (car lt2)))
	     (multiple-value-bind
		 (lt length)
		 (merge-ltrees (cdr lt1) (cdr lt2))
	       (if (eq lt t)
		   (values lt length)
		 (values (cons (car lt1) lt) (1+ length))))	     
	   (values t 0)))
	((< (cnf-lit-order-val (car lt1))
	    (cnf-lit-order-val (car lt2)))
	 (multiple-value-bind
	     (lt length)
	     (merge-ltrees (cdr lt1) lt2)
	   (if (eq lt t)
	       (values lt length)
	     (values (cons (car lt1) lt) (1+ length)))))
	(t
	 (multiple-value-bind
	     (lt length)
	     (merge-ltrees lt1 (cdr lt2))
	   (if (eq lt t)
	       (values lt length)
	     (values (cons (car lt2) lt) (1+ length)))))))

;;trees
(defun merge-clauses (c1 c2)
  (cond ((or (eq c1 t) (eq c2 t)) t)
	((eq c1 nil) c2)
	((eq c2 nil) c1)
	(*mergingp*
	 (multiple-value-bind
	     (ltree len)
	     (merge-ltrees (clause-ltree c1) (clause-ltree c2))
	   (if (= len 0)
	       ltree
	     (make-clause :len len
			  :ltree ltree))))
	((< (clause-len c1) (clause-len c2))
	 (make-clause :len (+ (clause-len c1) (clause-len c2))
		      :ltree (cons (clause-ltree c1)
				   (clause-ltree c2))))
	(t
	 (make-clause :len (+ (clause-len c1) (clause-len c2))
		      :ltree (cons (clause-ltree c2)
				   (clause-ltree c1))))))

(defun flatten-ltree (lt acc fhash)
  (cond ((atom lt) (cons lt acc))
	(acc
	 (flatten-ltree (first lt) (flatten-ltree (rest lt) acc fhash) fhash))
	(t
	 (let ((fr (gethash (rest lt) fhash)))
	   (setf (gethash lt fhash)
		 (flatten-ltree (first lt)
				(if fr fr (flatten-ltree (rest lt) acc fhash))
				fhash))))))

;; trees
(defun flatten-clause (c fhash)
  (flatten-ltree (clause-ltree c)
		 nil
		 fhash))
  
;; ;; lists
;; (defun flatten-clause (c fhash)
;;   (declare (ignore fhash))
;;   (clause-ltree c))

;; (defun print-clause (stream clause)
;;   (let ((c (simplify-clause clause)))
;;     (unless (eq c t)
;;       (format stream "~{~D ~}0~%" c))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; manolios + vroon                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
(defun ri-and-form (args)
  (make-formula :fn 'and :args args))

(defun ri-not-form (arg)
  (make-formula :fn 'not :args (list arg)))

(defun ri-or-form (args)
  (ri-not-form (ri-and-form (mapcar #'ri-not-form args))))

(defun remove-ifs-aux+ (form)
  (if (formula-slot1 form)
      (formula-slot1 form)
    (setf (formula-slot1 form)
	  (case (formula-fn form)
	    (var form)
	    (not (sb-not-form (remove-ifs-aux- (first (formula-args form)))))
	    (<-> (sb-equiv-form (mapcar #'remove-ifs-aux+ (formula-args form))))
	    (and (sb-and-form (mapcar #'remove-ifs-aux+ (formula-args form))))
	    (if (let* ((args (formula-args form))
		       (arg1 (first args))
		       (arg2 (second args))
		       (arg3 (third args)))
		  (sb-and-form (list (sb-or-form (list (sb-not-form (remove-ifs-aux- arg1))
						       (remove-ifs-aux+ arg2)))
				     (sb-or-form (list (remove-ifs-aux+ arg1)
						       (remove-ifs-aux+ arg3)))))))))))

(defun remove-ifs-aux- (form)
  (if (formula-slot2 form)
      (formula-slot2 form)
    (setf (formula-slot2 form)
	  (case (formula-fn form)
	    (var form)
	    (not (sb-not-form (remove-ifs-aux+ (first (formula-args form)))))
	    (<-> (sb-equiv-form (mapcar #'remove-ifs-aux- (formula-args form))))
	    (and (sb-and-form (mapcar #'remove-ifs-aux- (formula-args form))))
	    (if (let* ((args (formula-args form))
		       (arg1 (first args))
		       (arg2 (second args))
		       (arg3 (third args)))
		  (sb-or-form (list (sb-and-form (list (remove-ifs-aux- arg1)
						       (remove-ifs-aux- arg2)))
				    (sb-and-form (list (sb-not-form (remove-ifs-aux+ arg1))
						       (remove-ifs-aux- arg3)))))))))))

(defun remove-ifs (form)
  (let ((nform (remove-ifs-aux+ form)))
    (clear-both-slots form)
    nform))

(defun lin-and-form (args)
  (let ((nargs (and-args args)))
    (if (atom nargs)
	nargs
      (make-formula :fn 'and
		    :args nargs))))

(defun lin-not-form (arg)
  (let* ((fn (formula-fn arg)))
    (cond ((eq fn 'const)
	   (if (eq arg *zero*) *one* *zero*))
	  ((eq fn 'not)
	   (the formula (car (formula-args arg))))
	  (t
	   (make-formula :fn 'not
			 :args (list arg))))))

(defun lin-or-form (args)
  (lin-not-form (lin-and-form (mapcar #'lin-not-form args))))

(defun lin-var-form (args)
  (make-formula :fn 'var :args args))

(defun linearize-aux+ (form)
  (if (formula-slot1 form)
      (formula-slot1 form)
    (setf (formula-slot1 form)
	  (case (formula-fn form)
	    (var form)
	    (const form)
	    (not (lin-not-form (linearize-aux- (first (formula-args form)))))
	    (<-> (let* ((args (formula-args form))
			(arg1 (first args))
			(arg2 (second args)))
		   (linearize-aux+
		    (sb-and-form (list (sb-or-form (list (sb-not-form arg1)
							 arg2))
				       (sb-or-form (list arg1
							 (sb-not-form arg2))))))))
	    (and (lin-and-form (mapcar #'linearize-aux+ (formula-args form))))
	    (if (let* ((args (formula-args form))
		       (arg1 (first args))
		       (arg2 (second args))
		       (arg3 (third args)))
		  (linearize-aux+
		   (sb-and-form (list (sb-or-form (list (sb-not-form arg1)
							arg2))
				      (sb-or-form (list arg1
							arg3)))))))))))

(defun linearize-aux- (form)
  (if (formula-slot2 form)
      (formula-slot2 form)
    (setf (formula-slot2 form)
	  (case (formula-fn form)
	    (var form)
	    (const form)
	    (not (lin-not-form (linearize-aux+ (first (formula-args form)))))
	    (<-> (let* ((args (formula-args form))
			(arg1 (first args))
			(arg2 (second args)))
		   (linearize-aux-
		    (sb-not-form
		     (sb-and-form (list (sb-or-form (list arg1
							  arg2))
					(sb-or-form (list (sb-not-form arg1)
							  (sb-not-form arg2)))))))))
	    (and (lin-and-form (mapcar #'linearize-aux- (formula-args form))))
	    (if (let* ((args (formula-args form))
		       (arg1 (first args))
		       (arg2 (second args))
		       (arg3 (third args)))
		  (linearize-aux-
		   (sb-not-form
		    (sb-and-form (list (sb-or-form (list (sb-not-form arg1)
							 (sb-not-form arg2)))
				       (sb-or-form (list arg1
							 (sb-not-form arg3)))))))))))))

(defun linearize (form)
  (let ((nform (linearize-aux+ form)))
    (clear-both-slots form)
    nform))

;; (declaim (ftype (function (list list) (values boolean list)) merge-clauses1))
;; (defun merge-clauses1 (c1 c2)
;;   (cond ((endp c1) (values nil c2))
;; 	((endp c2) (values nil c1))
;; 	((< (abs (car c1)) (abs (car c2)))
;; 	 (multiple-value-bind
;; 	     (np ans)	    
;; 	     (merge-clauses1 (cdr c1) c2)
;; 	   (if np
;; 	       (values t nil)
;; 	     (values nil (cons (car c1) ans)))))
;; 	((= (car c1) (car c2))
;; 	 (multiple-value-bind
;; 	     (np ans)
;; 	     (merge-clauses1 (cdr c1) (cdr c2))
;; 	   (if np
;; 	       (values t nil)
;; 	     (values nil (cons (car c1) ans)))))
;; 	((= (car c1) (- (car c2)))
;; 	 (values t t))
;; 	(t
;; 	 (multiple-value-bind
;; 	     (np ans)
;; 	     (merge-clauses1 c1 (cdr c2))
;; 	   (if np
;; 	       (values t nil)
;; 	     (values nil (cons (car c2) ans)))))))

;; ;;NOTE: Changed merge clauses to append instead to save memory. We
;; ;;tried adding a second check to make sure that we put the shorter
;; ;;list in the front, but got a 10% slowdown and small memory savings.

;; (declaim (ftype (function (list list) list) merge-clauses))
;; (defun merge-clauses (c1 c2)
;;   (if (or (eq c1 t) (eq c2 t))
;;       t
;;     (append c1 c2)))

;;The version that checks lengths:
;;     (if (< (length c1) (length c2))
;; 	(append c1 c2)
;;       (append c2 c1))))

;;The old version:
;;     (multiple-value-bind
;; 	(np ans)
;; 	(merge-clauses1 c1 c2)
;;       (declare (ignore np))
;;       ans)))

(defun copy-clause-list (cl)
  (make-clause-list :cl-num (clause-list-cl-num cl)
		    :lit-num (clause-list-lit-num cl)
		    :max-cl-len (clause-list-max-cl-len cl)
		    :clauses (clause-list-clauses cl)))

(declaim (ftype (function (list) (or clause-list boolean)) append-clause-lists1))
(defun append-clause-lists1 (args)
  (cond ((endp args) t)
	((clause-list-p (car args))
	 (let ((lst (append-clause-lists1 (cdr args))))
	   (cond ((eq lst nil) nil)
		 ((eq (car args) t) lst)
		 ((eq lst t) 
		  (let ((arg (car args)))
		    (copy-clause-list arg)))
		 (t 
		  (let ((arg (car args)))
		    (setf (clause-list-cl-num lst) (+ (clause-list-cl-num lst)
						      (clause-list-cl-num arg)))
		    (setf (clause-list-lit-num lst) (+ (clause-list-lit-num lst)
						       (clause-list-lit-num arg)))
		    (setf (clause-list-max-cl-len lst) (max (clause-list-max-cl-len lst)
							    (clause-list-max-cl-len arg)))
		    (setf (clause-list-clauses lst) 
			  (if (< (clause-list-cl-num lst)
				 (clause-list-cl-num arg))
			      (append (clause-list-clauses lst)
				      (clause-list-clauses arg))
			    (append (clause-list-clauses arg)
				    (clause-list-clauses lst))))
		    lst)))))
	((eq (car args) nil) nil)
	(t (append-clause-lists1 (cdr args)))))

(declaim (ftype (function (&rest list) (or boolean clause-list)) append-clause-lists))
(defun append-clause-lists (&rest args)
;;  (loop for arg in args unless arg do (break))
  (let ((sargs (sort (copy-list args) #'< :key (lambda (x)
						 (if (clause-list-p x)
						     (clause-list-cl-num x)
						   0)))))
    (append-clause-lists1 sargs)))

;returns the cartesian product of two lists of clauses: l1 and l2
(declaim (ftype (function (list list) (or list (eql t))) cart-prod))
(defun cart-prod (l1 l2)
  (let ((prod nil)
	(nlits 0)
	(nclauses 0)
	(mlen 0))
    (loop for clause1 in l1
	  do (loop for clause2 in l2
		   for mc = (merge-clauses clause1 clause2)
		   unless (eq mc t)
		     do (setf prod (cons mc prod))
		     and do (incf nclauses)
		     and do (incf nlits (clause-len mc))
		     and do (setf mlen (max mlen (clause-len mc)))))
    (cond ((endp prod) (values t 0 0 0))
	  (t (values prod nclauses nlits mlen)))))
;;   (if (or (eq l1 t) (eq l2 t))
;;       t
;;     (let ((prod nil))
;;       (dolist (elt1 l1 (or prod t)) ;;if prod is nil, the cart-prod is vacuously true.
;; 	(dolist (elt2 l2 nil)
;; 	  (let ((mc (merge-clauses elt1 elt2)))
;; 	    (unless (eq mc t) (setf prod (cons mc prod)))))))))

;; ;returns the cartesian product of two or more lists.
;; (defmacro cart-prod (l1 l2 &rest lsts)
;;   (if (endp lsts)
;;       `(binary-cart-prod ,l1 ,l2)
;;     `(binary-cart-prod ,l1 (cart-prod ,l2 ,@lsts))))

;; ;applies the cartesian product to a list of lists.
;; (declaim (ftype (function (list) (or list (eql t))) cart-prod-list))
;; (defun cart-prod-list (lst)
;;   (cond ((endp lst) nil)
;; 	((endp (cdr lst)) (the (or list (eql t)) (car lst)))
;; 	(t (cart-prod (car lst) (cart-prod-list (cdr lst))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; translation to aig with or without meta ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun sort-by-depth-aux (form array)
  (when (and (formula-p form)
	     (not (formula-slot1 form)))
    (setf (formula-slot1 form) t)
    (setf (aref array (formula-depth form))
	  (cons form (aref array (formula-depth form))))
    (loop for arg in (formula-args form)
	  do (sort-by-depth-aux arg array))))

(defun sort-by-depth (form)
  (let ((array (make-array (1+ (formula-depth form)) :initial-element nil)))
    (sort-by-depth-aux  form array)
    (clear-slot1 form)
    array))
	  
(defun list-length-equal (lst len)
  (cond ((endp lst) (= len 0))
	((<= len 0) nil)
	(t
	 (list-length-equal (cdr lst) (1- len)))))

(defun meta-form (pos neg)
  (make-unique-formula :fn 'meta
		       :args (list pos neg)))

(defun make-if-meta-node (test then else)
  (let* ((ntest (sb-not-form test))
	 (pos (sb-and-form (list (sb-or-form (list ntest then))
				 (sb-or-form (list test else)))))
	 (neg (sb-and-form (list (sb-or-form (list ntest (sb-not-form then)))
				 (sb-or-form (list test (sb-not-form else))))))
	 (mnode (meta-form pos (sb-not-form neg)))
	 (nmnode (sb-not-form mnode)))
    (setf (formula-slot1 pos) mnode)
    (setf (formula-slot1 neg) nmnode)
    mnode))

(defun make-iff-meta-node (arg1 arg2)
  (make-if-meta-node arg1 arg2 (sb-not-form arg2)))

(defun matching-sb-and-form-aux (nform)
  (case (formula-fn nform)
    (not (sb-not-form (matching-sb-and-form-aux (first (formula-args nform)))))
    (<-> (let ((args (formula-args nform)))
	   (make-iff-meta-node (first args) (second args))))
    (if
     (let ((args (formula-args nform)))
       (make-if-meta-node (first args) (second args) (third args))))
    (otherwise nform)))

(defun matching-sb-and-form (args)
  (if (not (and (list-length-equal args 2)
		(eq (formula-fn (first args)) 'not)
		(eq (formula-fn (second args)) 'not)))
      (sb-and-form args)	   
    (let* ((narg1 (first (formula-args (first args))))
	   (narg2 (first (formula-args (second args))))
	   (nargs1 (formula-args narg1))
	   (nargs2 (formula-args narg2)))
      (if (not (and (eq (formula-fn narg1) 'and)
		    (eq (formula-fn narg2) 'and)
		    (list-length-equal nargs1 2)
		    (list-length-equal nargs2 2)))
	  (sb-and-form args)
	(let* ((x11 (first nargs1))
	       (nx11 (sb-not-form x11))
	       (x12 (second nargs1))
	       (nx12 (sb-not-form x12))
	       (x21 (first nargs2))
	       (x22 (second nargs2)))
	  (cond ((eq nx11 x21) 
		 (matching-sb-and-form-aux (sb-if-form x11 x12 x22)))
		((eq nx11 x22)
		 (matching-sb-and-form-aux (sb-if-form x11 x12 x21)))
		((eq nx12 x21)
		 (matching-sb-and-form-aux (sb-if-form x12 x11 x22)))
		((eq nx12 x22)
		 (matching-sb-and-form-aux (sb-if-form x12 x11 x21)))
		(t (sb-and-form args))))))))
    
(defun nice-to-aig+meta (form)
  (let ((array (sort-by-depth form)))
    (loop for form-list across array
	  do (loop for form in form-list
		   do (setf (formula-slot1 form)
			    (case (formula-fn form)
			      (var form)
			      (const form)
			      (not (sb-not-form (formula-slot1 (first (formula-args form)))))
			      (and (let ((args (mapcar #'formula-slot1
						       (formula-args form))))
				     (if *matchingp*
					 (matching-sb-and-form args)
				       (sb-and-form args))))
			      (<-> (let ((args (mapcar #'formula-slot1 (formula-args form))))
				     (make-iff-meta-node (first args) (second args))))
			      (if  (let ((args (mapcar #'formula-slot1 (formula-args form))))
				     (make-if-meta-node (first args) (second args) (third args))))
			      (otherwise
			       (break (format nil "nice-to-aig+meta: unexpected function: ~A~%"
					      (formula-fn form)))))))
	  finally (return (let ((nform (formula-slot1 form)))
			    (clear-slot1 form)
			    (scrub-slots nform)
			    nform)))))
			      
;; (defun nice-to-aig+meta-aux (form)
;;   (cond ((member (formula-fn form) '(const var) :test 'eq)
;; 	 form)
;; 	((formula-slot2 form)
;; 	 (formula-slot2 form))
;; 	(t
;; 	 (case (formula-fn form)
;; 	   (<-> (let* ((args (mapcar #'nice-to-aig+meta-aux (formula-args form)))
;; 		       (arg1 (first args))
;; 		       (narg1 (sb-not-form arg1))
;; 		       (arg2 (second args))
;; 		       (narg2 (sb-not-form arg2))
;; 		       (pos (sb-and-form (list (sb-or-form (list narg1 arg2))
;; 					       (sb-or-form (list arg1 narg2)))))
;; 		       (npos (sb-not-form pos))
;; 		       (neg (sb-or-form (list (sb-and-form (list arg1 arg2))
;; 					      (sb-and-form (list narg1 narg2)))))
;; 		       (nneg (sb-not-form neg))
;; 		       (mnode (meta-form pos neg))
;; 		       (nmnode (sb-not-form mnode)))
;; 		  (setf (formula-slot1 pos)
;; 			(setf (formula-slot1 neg)
;; 			      mnode))
;; 		  (setf (formula-slot1 npos)
;; 			(setf (formula-slot1 nneg)
;; 			      nmnode))
;; 		  (setf (formula-slot2 form)
;; 			mnode)))
;; 	   (if (setf (formula-slot2 form)
;; 		     (let* ((args (mapcar #'nice-to-aig+meta-aux (formula-args form)))
;; 			    (test (first args))
;; 			    (ntest (sb-not-form test))
;; 			    (then (second args))
;; 			    ;;(nthen (sb-not-form then))
;; 			    (else (third args))
;; 			    ;;(nelse (sb-not-form else))
;; 			    (pos (sb-and-form (list (sb-or-form (list ntest then))
;; 						    (sb-or-form (list test else)))))
;; 			    (npos (sb-not-form pos))
;; 			    (neg (sb-or-form (list (sb-and-form (list test then))
;; 						   (sb-and-form (list ntest else)))))
;; 			    (nneg (sb-not-form neg))
;; 			    (mnode (meta-form pos neg))
;; 			    (nmnode (sb-not-form mnode)))
;; 		       (setf (formula-slot1 pos)
;; 			     (setf (formula-slot1 neg)
;; 				   mnode))
;; 		       (setf (formula-slot1 npos)
;; 			     (setf (formula-slot1 nneg)
;; 				   nmnode))
;; 		       (setf (formula-slot2 form)
;; 			     mnode))))
;; 		 (not (setf (formula-slot2 form)
;; 			    (sb-not-form (nice-to-aig+meta-aux (first (formula-args form))))))
;; 		 (and (setf (formula-slot2 form)
;; 			    (sb-and-form (mapcar #'nice-to-aig+meta-aux (formula-args form)))))
;; 		 (otherwise 
;; 		  (format nil "nice-to-aig+meta: unexpected function: ~A~%"
;; 			  (formula-fn form)))))))
	   
;; (defun nice-to-aig+meta-aux1-body (form)
;;   (cond ((member (formula-fn form) '(const var) :test 'eq)
;; 	 form)
;; 	((formula-slot2 form)
;; 	 (formula-slot2 form))
;; 	(t
;; 	 (let ((args (formula-args form)))
;; 	   (setf (formula-slot2 form)
;; 		 (case (formula-fn form)
;; 		   (meta (meta-form (nice-to-aig+meta-aux1-body (first args))
;; 				    (nice-to-aig+meta-aux1-body (second args))))
;; 		   (and (sb-and-form (mapcar #'nice-to-aig+meta-aux1 args)))
;; 		   (not (sb-not-form (nice-to-aig+meta-aux1-body (first args))))
;; 		   (otherwise 
;; 		    (break (format nil "nice-to-aig+meta-aux1: unexpected function: ~A~%"
;; 				   (formula-fn form))))))))))

;; (defun nice-to-aig+meta-aux1 (form)
;;   (if (formula-slot1 form)
;;       (setf (formula-slot2 form)
;; 	    (nice-to-aig+meta-aux1 (formula-slot1 form)))
;;     (nice-to-aig+meta-aux1-body form)))
	   
;; (defun nice-to-aig+meta2 (form)
;;   (let ((form (nice-to-aig+meta-aux form)))
;;     (clear-slot2 form)
;;     (let ((form (nice-to-aig+meta-aux1 form)))
;;       (clear-both-slots form)
;;       form)))

(defun lit-for-var+ (var)
  (let ((lit (make-cnf-lit :var var :pol t)))
    (setf (cnf-var-lit+ var) lit)
    lit))

(defun lit-for-var- (var)
  (let ((lit (make-cnf-lit :var var :pol nil)))
    (setf (cnf-var-lit- var) lit)
    lit))

(defun cnf-lit-neg (lit)
  (if (cnf-lit-pol lit)
      (cnf-var-lit- (cnf-lit-var lit))
    (cnf-var-lit+ (cnf-lit-var lit))))

(defun cnf-lit-order-val (lit)
  (cnf-var-order-val (cnf-lit-var lit)))

(defun new-cnf-var-for-form (form)
  (let* ((var (make-cnf-var :order-val (incf *order-val*)
			    :form form
			    :intermediatep (not (eq (formula-fn form) 'var))))
	 (plit (make-cnf-lit :var var
			     :pol t))
	 (nlit (make-cnf-lit :var var
			     :pol nil)))
    (setf (cnf-var-lit+ var) plit)
    (setf (cnf-var-lit- var) nlit)
    var))

(defun lit-for-form+ (form)
  (if (eq (formula-fn form) 'not)
      (lit-for-form- (first (formula-args form)))
    (let* ((sb (clauses- form))
	   (lit (if (single-lit-clausesp sb)
		    (cnf-lit-neg (slc-get-lit sb))
		  (cnf-var-lit+ (new-cnf-var-for-form form)))))
      (when (eq (cnf-var-form (cnf-lit-var lit)) form)
	(setf (cnf-lit-implies lit) (or-clauses (clauses-for-lit (cnf-lit-neg lit))
						(clauses+ form))))
      ;;(format t "creating lit ~A for clauses ~A~%" lit (clauses+ form))
      (set-clauses+ form (clauses-for-lit lit)))))

(defun lit-for-form- (form)
  (if (eq (formula-fn form) 'not)
      (lit-for-form+ (first (formula-args form)))
    (let* ((sb (clauses+ form))
	   (lit (if (single-lit-clausesp sb)
		    (cnf-lit-neg (slc-get-lit sb))
		  (cnf-var-lit- (new-cnf-var-for-form form)))))
      (when (eq (cnf-var-form (cnf-lit-var lit)) form)
	(setf (cnf-lit-implies lit) (or-clauses (clauses-for-lit (cnf-lit-neg lit))
						(clauses- form))))
      ;;(format t "creating lit ~A for clauses ~A~%" lit (clauses- form))
      (set-clauses- form (clauses-for-lit lit)))))

;counts the number of times a subformula is shared (multiple
;in-edges). for not formulas, the child's counter is incremented as
;well.

(declaim (ftype (function (t) null) count-shares-with-pol+))
(defun count-shares-with-pol+ (form)
  (when (formula-p form)
    (unless (natp (formula-slot1 form)) (setf (formula-slot1 form) 0))
    (cond ((eq (formula-fn form) 'not) (count-shares-with-pol- (first (formula-args form))))
	  ((= (formula-slot1 form) 0)
	   (case (formula-fn form)
;; 	     (<-> (let* ((args (formula-args form))
;; 			 (arg1 (first args))
;; 			 (arg2 (second args))
;; 			 (arg3 (sb-or-form (list arg1
;; 						 (sb-not-form arg2))))
;; 			 (arg4 (sb-or-form (list (sb-not-form arg1)
;; 						 arg2)))
;; 			 (arg5 (fifth args))
;; 			 (arg6 (sixth args)))
;; 		    (setf (formula-args form) (list arg1 arg2 arg3 arg4 arg5 arg6))
;; 		    (count-shares-with-pol+ arg3)
;; 		    (count-shares-with-pol+ arg4)))
;; 	     (if (let* ((args (formula-args form))
;; 			(arg1 (first args))
;; 			(arg2 (second args))
;; 			(arg3 (third args))
;; 			(arg4 (sb-or-form (list (sb-not-form arg1)
;; 						arg2)))
;; 			(arg5 (sb-or-form (list arg1 arg3)))
;; 			(arg6 (sixth args))
;; 			(arg7 (seventh args)))
;; 		   (setf (formula-args form) (list arg1 arg2 arg3 arg4 arg5 arg6 arg7))
;; 		   (count-shares-with-pol+ arg4)
;; 		   (count-shares-with-pol+ arg5)))
	     (meta
	      (count-shares-with-pol+ (first (formula-args form))))
	     (otherwise
	      (dolist (arg (formula-args form)) (count-shares-with-pol+ arg))))))
    (incf (formula-slot1 form))
    nil))

(declaim (ftype (function (t) null) count-shares-with-pol-))
(defun count-shares-with-pol- (form)
  (when (formula-p form)
    (unless (natp (formula-slot2 form)) (setf (formula-slot2 form) 0))
    (cond ((eq (formula-fn form) 'not) (count-shares-with-pol+ (first (formula-args form))))
	  ((= (formula-slot2 form) 0)
	   (case (formula-fn form)
;; 	     (<-> (let* ((args (formula-args form))
;; 			 (arg1 (first args))
;; 			 (arg2 (second args))
;; 			 (arg3 (third args))
;; 			 (arg4 (fourth args))
;; 			 (arg5 (sb-or-form (list (sb-not-form arg1)
;; 						 (sb-not-form arg2))))
;; 			 (arg6 (sb-or-form (list arg1 arg2))))
;; 		    (setf (formula-args form) (list arg1 arg2 arg3 arg4 arg5 arg6))
;; 		    (count-shares-with-pol+ arg5)
;; 		    (count-shares-with-pol+ arg6)))
;; 	     (if (let* ((args (formula-args form))
;; 			  (arg1 (first args))
;; 			  (arg2 (second args))
;; 			  (arg3 (third args))
;; 			  (arg4 (fourth args))
;; 			  (arg5 (fifth args))
;; 			  (arg6 (sb-or-form (list (sb-not-form arg1)
;; 						  (sb-not-form arg2))))
;; 			  (arg7 (sb-or-form (list arg1 (sb-not-form arg3)))))
;; 		     (setf (formula-args form) (list arg1 arg2 arg3 arg4 arg5 arg6 arg7))
;; 		     (count-shares-with-pol+ arg6)
;; 		     (count-shares-with-pol+ arg7)))
	     (meta
	      (count-shares-with-pol- (second (formula-args form))))
	     (otherwise
	      (dolist (arg (formula-args form)) (count-shares-with-pol- arg))))))
    (incf (formula-slot2 form))
    nil))

(declaim (ftype (function (t) null) count-shares-with-pol))
(defun count-shares-with-pol (form)
  (count-shares-with-pol+ form))

(defun ls-fix-slot (slot)
  (cond ((null slot) (cons 'dna nil))
	((> slot 1) (cons 'share t))
	(t (cons 'noshare t))))

(defun label-shares2-aux (form)
  (when (and (formula-p form)
	     (not (consp (formula-slot1 form))))
    (setf (formula-slot1 form)
	  (ls-fix-slot (formula-slot1 form)))
    (setf (formula-slot2 form)
	  (ls-fix-slot (formula-slot2 form)))
    (mapcar #'label-shares2-aux (formula-args form))))

(defun label-shares2 (form)
  (count-shares-with-pol+ form)
  (label-shares2-aux form))
	  
    

;;   (when (formula-p form)
;;     (unless (natp (formula-slot1 form)) (setf (formula-slot1 form) 0))
;;     (when (or (= (formula-slot1 form) 0)
;; 	      (eq (formula-fn form) 'not))
;;       (mapcar #'count-shares (formula-args form)))
;;     (incf (formula-slot1 form)))
;;   nil)


;creates a temp variable name given a number, i.
(declaim (ftype (function (fixnum) formula) temp-var))
(defun temp-var (i) 
  (make-formula :fn 'var
		:args (list (read-from-string (format nil "_T~a" i)) 0 0)))

;creates a new temp var. *counter* keeps track of how many we've made.
(declaim (ftype (function () formula) new-temp-var))
(defun new-temp-var ()
  (let ((c (temp-var *counter*)))
    (incf *counter*)
    c))

;compares the cars of ci1 and ci2. this is used for sorting clauseinfo
;later. clauseinfo will be a pair whose cdr is a list and whose car is
;the length of that list. we put them in a pair so we don't have to
;recompute the length.
(declaim (ftype (function ((cons fixnum t) (cons fixnum t)) boolean) ci>))
(defun ci> (ci1 ci2)
  (> (car ci1) (car ci2)))

;; (declaim (ftype (function ((or cons boolean fixnum)) boolean) single-lit-clausesp))
;; (defun single-lit-clausesp (clauses)
;;   (and (consp clauses)
;;        (consp (car clauses))
;;        (endp (cdar clauses))
;;        (endp (cdr clauses))))

;; (defmacro slc-get-lit (clauses)
;;   `(caar ,clauses))

;; (declaim (ftype (function (fixnum formula) null) set-lit-to-form+))
;; (defun set-lit-to-form+ (lit form)
;;   (setf *sforms*
;; 	(append-clause-lists (or-clauses (clauses-for-lit (- lit)) (comp+ form))
;; 			     *sforms*))
;;   nil)

;; (declaim (ftype (function (fixnum formula) null) set-lit-to-form-))
;; (defun set-lit-to-form- (lit form)
;;   (setf *sforms*
;; 	(append-clause-lists (or-clauses (clauses-for-lit (- lit)) (comp- form))
;; 			     *sforms*))
;;   nil)

(defun list-limit (list limit)
  (or (endp list)
      (and (not (zp limit))
	   (list-limit (rest list) (1- limit)))))

(defun all-clauses-limit (clause-list limit)
  (< (clause-list-max-cl-len clause-list) limit))
;;   (or (endp clause-list)
;;       (and ;(list-limit (first clause-list) limit)
;; 	   (<= (clause-len (first clause-list)) limit)
;; 	   (all-clauses-limit (rest clause-list) limit))))
    
(defun dest-or-clauses (c1 c2)
  (cond ((or (eq c1 t) (eq c2 t))
	 t)
	((eq c1 nil) c2)
	((eq c2 nil) c1)
	(t 
	 (multiple-value-bind
	     (prod nclauses nlits mlen)
	     (cart-prod (clause-list-clauses c1)
			(clause-list-clauses c2))
	   (cond ((eq prod t) t)
		 (t
		  (setf (clause-list-cl-num c1) nclauses)
		  (setf (clause-list-lit-num c1) nlits)
		  (setf (clause-list-max-cl-len c1) mlen)
		  (setf (clause-list-clauses c1) prod)
		  c1))))))
;;     (let ((prod nil))
;;       (dolist (elt1 l1 (or prod t)) ;;if prod is nil, the cart-prod is vacuously true.
;; 	(dolist (elt2 l2 nil)
;; 	  (let ((mc (merge-clauses elt1 elt2)))
;; 	    (unless (eq mc t) (setf prod (cons mc prod))))))))

;;   (let ((cn1 (clause-list-cl-num c1))
;; 	(cn2 (clause-list-cl-num c2))
;; 	(ln1 (clause-list-lit-num c1))
;; 	(ln2 (clause-list-lit-num c2)))



;;     (setf (clause-list-cl-num c1)
;; 	  (* cn1 cn2))
;;     (setf (clause-list-lit-num c1)
;; 	  (+ (* cn1 ln2) (* cn2 ln1)))
;;     (setf (clause-list-max-cl-len c1)
;; 	  (+ (clause-list-max-cl-len c1)
;; 	     (clause-list-max-cl-len c2)))
;;     (let ((cp (if (< (* ln1 cn2) (* cn1 ln2))
;; 		  (cart-prod (clause-list-clauses c1)
;; 			     (clause-list-clauses c2))
;; 		(cart-prod (clause-list-clauses c2)
;; 			   (clause-list-clauses c1)))))
;;       (cond ((eq cp t) t)
;; 	    (t (setf (clause-list-clauses c1)
;; 		     cp)
;; 	       c1)))))

;; (defun or-clauses-aux (cn1 ln1 mcl1 c1 cn2 ln2 mcl2 c2)
;;   (values (* cn1 cn2) ;; new number of clauses
;; 	  (+ (* cn1 ln2) (* cn2 ln1)) ;; new number of literals
;; 	  (+ mcl1 mcl2) ;; new max clause length
;; 	  (cart-prod c1 c2))) ;; new clauses

(defun or-clauses (c1 c2)
  (cond ((or (eq c1 t) (eq c2 t))
	 t)
	((eq c1 nil) c2)
	((eq c2 nil) c1)
	(t 
	 (multiple-value-bind
	     (prod nclauses nlits mlen)
	     (cart-prod (clause-list-clauses c1)
			(clause-list-clauses c2))
	   (cond ((eq prod t) t)
		 (t
		  (make-clause-list :cl-num nclauses
				    :lit-num nlits
				    :max-cl-len mlen
				    :clauses prod)))))))

(defun or-clauses-list (cl)
  (let ((ncl (copy-clause-list (first cl))))
    (dolist (cl (rest cl) ncl)
      (setf ncl (dest-or-clauses ncl cl))
      (when (eq ncl t) (return ncl)))))
     
(declaim (ftype (function (list) (or clause-list boolean)) dis-clauses-min-lits))
(defun dis-clauses-min-lits (args)
  (let ((nargs (loop for arg in args
		     for cl = (comp- arg)
		     if (eq cl t)
		     return t
		     else unless (eq cl nil)
		     collect arg)))
    (if (endp nargs)
	t
      (let* ((sargs (sort nargs
			  #'<
			  :key (lambda (x)
				 (clause-list-lit-num (clauses- x)))))
	     (cl (copy-clause-list (clauses- (first sargs)))))
	(if *tryp*
	    (loop for arg in (rest sargs)
		  for cli = (clauses- arg)
		  for lit = (if (single-lit-clausesp cli)
				cli
			      (lit-for-form- arg))
		  for wv = (or-clauses cl lit)
		  for wov = (or-clauses cl cli)
		  if (or (eq wv t) (eq wov t))
		  return t
		  else when (and wv wov)
		  if (<= (clause-list-lit-num wov)
			 (+ (clause-list-lit-num wv)
			    (clause-list-lit-num cli)
			    (clause-list-cl-num cli)))
		  do (progn (setf cl wov)
			    (set-clauses- arg cli))
		  else do (setf cl wv)
		  when (eq cl t) return t
		  finally (return cl))
	  (loop for arg in (rest sargs)
		for cli = (clauses- arg)
		if (<= (+ (* (clause-list-cl-num cl)
			     (clause-list-lit-num cli))
			  (* (clause-list-cl-num cli)
			     (clause-list-lit-num cl)))
		       (+ (clause-list-lit-num cli)
			  (clause-list-lit-num cl)
			  (clause-list-cl-num cl)
			  1))
		do (setf cl (dest-or-clauses cl cli))
		else
		do (setf cl (dest-or-clauses cl
					     (lit-for-form- arg)))
		when (eq cl t) return t
		finally (return cl)))))))
	

(declaim (ftype (function (list) (or clause-list boolean)) dis-clauses-min-clauses))
(defun dis-clauses-min-clauses (args)
  (let ((nargs (loop for arg in args
		     for cl = (comp- arg)
		     if (eq cl t)
		     return t
		     else unless (eq cl nil)
		     collect arg)))
    (if (endp nargs)
	t
      (let* ((sargs (sort nargs
			  #'<
			  :key (lambda (x)
				 (clause-list-cl-num (clauses- x)))))
	     (cl (copy-clause-list (clauses- (first sargs)))))
	(if *tryp*
	    (loop for arg in (rest sargs)
		  for cli = (clauses- arg)
		  for lit = (if (single-lit-clausesp cli)
				cli
			      (lit-for-form- arg))
		  for wv = (or-clauses cl lit)
		  for wov = (or-clauses cl cli)
		  if (or (eq wv t) (eq wov t))
		  return t
		  else when (and wv wov)
		  if (<= (clause-list-cl-num wov)
			 (+ (clause-list-cl-num wv)
			    (clause-list-cl-num cli)))
		  do (progn (setf cl wov)
			    (set-clauses- arg cli))
		  else do (setf cl wv)
		  finally (return cl))
	  (loop for arg in (rest sargs)
		for cli = (clauses- arg)
		if (<= (* (clause-list-lit-num cli)
			  (clause-list-lit-num cl))
		       (+ (clause-list-lit-num cli)
			  (clause-list-lit-num cl)))
		do (dest-or-clauses cl cli)
		else
		do (dest-or-clauses cl
				    (lit-for-form- arg))
		finally (return cl)))))))

	
;; ;args should already have had comp run on them. clengths is the
;; ;lengths of the negated clauses of the args everything should be
;; ;sorted so that the args are in decreasing order of their clengths,
;; ;and the clengths are also in decreasing order. this isn't quite the
;; ;same as in the paper, where they assume and is binary. so, we pull a
;; ;trick by using the sorted list and picking out the biggest thing each
;; ;time.
;; (declaim (ftype (function (list integer clause-list) (or clause-list boolean)) dis-clauses1))
;; (defun dis-clauses1 (arg-len-pairs clen clauses)
;;   (if (endp arg-len-pairs)
;;       clauses
;;   ;; (format t "~&dis-clauses1~%")
;;     (let* ((arg-len-pair (car arg-len-pairs))
;; 	   (arg (car arg-len-pair))
;; 	   (len (cdr arg-len-pair))
;; 	   (prod (* len clen))
;; 	   (sum (+ len clen)))
;;       (cond ((< sum prod)
;; 	     (let ((lit-clauses-list (mapcar (lambda (x) 
;; 					       (lit-for-form- (car x)))
;; 					     arg-len-pairs)))
;; 	       (or-clauses (or-clauses-list lit-clauses-list) clauses)))
;; 	    (t
;; 	     (unless (all-clauses-limit (comp- arg) 10)
;; 	       (lit-for-form- arg))
;; 	     (let ((nclauses (or-clauses clauses (comp- arg))))
;; 	       (if (eq nclauses t)
;; 		   t
;; 		 (dis-clauses1 (cdr arg-len-pairs) prod nclauses))))))))

;; ;; returns t if comp- is t for any arg.
;; ;; otherwise returns the lengths and clauses for all non-nil clauses.
;; (declaim (ftype (function (list) (values list (or list (eql t)))) clauseinfo))
;; (defun clauseinfo (args)
;;   (loop for i in 
;; 	collect (car i) into cari
;; 	collect (cdr i) into cdri
;; 	finally (return (values cari cdri))))

;; (declaim (ftype (function (list) (or clause-list boolean)) dis-clauses-min-clauses))
;; (defun dis-clauses-min-clauses (args)
;;   (let ((arg-len-pairs (loop for arg in args
;; 			     for clauses = (comp- arg)
;; 			     when (eq clauses t) return t
;; 			     when clauses
;; 			       collect (cons arg (clause-list-cl-num clauses)) into arg-len-pairs
;; 			     finally (return (sort arg-len-pairs #'< :key #'cdr)))))
;;     (if (atom arg-len-pairs)
;; 	arg-len-pairs
;;       (dis-clauses1 (cdr arg-len-pairs)
;; 		    (cdar arg-len-pairs)
;; 		    (comp- (caar arg-len-pairs))))))
	
(declaim (ftype (function (list (or clause-list boolean))
			  (or clause-list boolean))
		dis-clauses-all-aux))
(defun dis-clauses-all-aux (args acc)
  (if (endp args)
      acc
    (let* ((arg (first args))
	   (arg-cl (comp- arg)))
      (dis-clauses-all-aux (cdr args)
			   (or-clauses (cond ((single-lit-clausesp arg-cl)
					      arg-cl)
					     (t
					      (lit-for-form- arg)))
				       acc)))))

(declaim (ftype (function (list) (or clause-list boolean)) dis-clauses-all))
(defun dis-clauses-all (args)
  (dis-clauses-all-aux args nil))

;; forms the disjunction of the clauses of the forms of args
(declaim (ftype (function (list) (or clause-list boolean)) dis-clauses))
(defun dis-clauses (args)
  (case *var-policy*
    (lits (dis-clauses-min-lits args))
    (clauses (dis-clauses-min-clauses args))
    (all (dis-clauses-all args))
    (otherwise (break (format nil "dis-clauses: unknown var introduction policy: ~A~%"
			      *var-policy*)))))


;;(cdr nargs) (cdr clengths) (car clengths) (comp- (car nargs))))))

(declaim (ftype (function (list) formula) comp-and-form))
(defun comp-and-form (args)
  (make-formula :fn 'and
		:slot1 1
		:slot2 1
		:args args))

(declaim (ftype (function (formula) formula) comp-not-form))
(defun comp-not-form (arg)
  (if (eq (formula-fn arg) 'not)
      (car (formula-args arg))
    (make-formula :fn 'not 
		  :slot1 1
		  :slot2 1
		  :args (list arg))))

(declaim (ftype (function (list) formula) comp-or-form))
(defun comp-or-form (args)
  (comp-not-form (comp-and-form (mapcar #'comp-not-form args))))

(defun clauses- (form)
  (if (eq (formula-fn form) 'not)
      (formula-slot1 (first (formula-args form)))
    (formula-slot2 form)))

(defun clauses+ (form)
  (if (eq (formula-fn form) 'not)
      (formula-slot2 (first (formula-args form)))
    (formula-slot1 form)))

(defun set-clauses- (form cl)
  (if (eq (formula-fn form) 'not)
      (setf (formula-slot1 (first (formula-args form)))
	    cl)
    (setf (formula-slot2 form) cl)))

(defun set-clauses+ (form cl)
  (if (eq (formula-fn form) 'not)
      (setf (formula-slot2 (first (formula-args form)))
	    cl)
    (setf (formula-slot1 form) cl)))

;comp with positive polarity
(declaim (ftype (function (formula) (or clause-list boolean)) comp+))
(defun comp+ (form)
  (cond ((eq (formula-fn form) 'not)
	 (comp- (first (formula-args form))))
	((not (consp (formula-slot1 form)))
	 (formula-slot1 form))
        (t
	 ;; (when (= (formula-slot1 form) 0) (break))
	 ;; (format t " recursive")
         (let ((shares (formula-slot1 form)))
           (setf (formula-slot1 form)
		 (case (formula-fn form)
		   (var (let ((cnf-var (new-cnf-var-for-form form)))	  
			  (setf (formula-slot2 form)
				(clauses-for-lit (cnf-var-lit- cnf-var)))
			  (clauses-for-lit (cnf-var-lit+ cnf-var))))
		   (and (apply #'append-clause-lists 
			       (mapcar #'comp+ (formula-args form))))
;;		   (not (comp- (car (formula-args form))))
		   (meta (comp+ (first (formula-args form))))
;; 		   (<-> (comp+ (comp-and-form (list (third (formula-args form))
;; 						    (fourth (formula-args form))))))
;; 		   (if (comp+ (comp-and-form (list (fourth (formula-args form))
;; 						   (fifth (formula-args form))))))
		   (otherwise (format t "comp+: unexpected function: ~A~%" form))))
	   (cond ((typep (formula-slot1 form) 'boolean)
		  (setf (formula-slot2 form) 
			(not (formula-slot1 form))))
		 ((and (eq (car shares) 'share)
;;		       (consp (cdr (formula-slot1 form))))
		       (not (single-lit-clausesp (formula-slot1 form)))
		       (or (not *or-parp*)
			   (cdr shares)))
;; 		       (or (consp (cdr (formula-slot1 form)))
;; 			   (not (list-limit (first (formula-slot1 form)) 20))))
		  (lit-for-form+ form)))
;; 	   (when (and (integerp (formula-slot2 form))
;; 		      (> (formula-slot2 form) 0))
;; 	     (comp- form))
;;	   (when (typep (formula-slot1 form) 'boolean) (break))
;;	   (format t "comp+:~%  form: ~A~%  clauses: ~A~%~%" form (formula-slot1 form))
;;	   (when (and (clause-list-p (formula-slot1 form)
	   (formula-slot1 form)))))

;comp with negative polarity
(declaim (ftype (function (formula) (or clause-list boolean)) comp-))
(defun comp- (form)
  ;; (format t "~&comp-: slot1: ~A slot2: ~A~%" (formula-slot1 form) (formula-slot2 form))
  (cond ((eq (formula-fn form) 'not)
	 (comp+ (first (formula-args form))))
	((not (consp (formula-slot2 form)))
	 (formula-slot2 form))
        (t
	 ;; (when (= (formula-slot2 form) 0) (break))
	 ;; (format t " recursive")
         (let ((shares (formula-slot2 form)))
           (setf (formula-slot2 form)
		 (case (formula-fn form)
		   (var (let ((cnf-var (new-cnf-var-for-form form)))
			  (setf (formula-slot1 form)
				(clauses-for-lit (cnf-var-lit+ cnf-var)))
			  (clauses-for-lit (cnf-var-lit- cnf-var))))
		   (and (dis-clauses (formula-args form)))
;;		   (not (comp+ (first (formula-args form))))
		   (meta (comp- (second (formula-args form))))
;; 		   (<-> (comp+ (comp-and-form (list (fifth (formula-args form))
;; 						    (sixth (formula-args form))))))
;; 		   (if (comp+ (comp-and-form (list (sixth (formula-args form))
;; 						   (seventh (formula-args form))))))
		   (otherwise (format t "comp-: unexpected function: ~A~%" form) (break))))
	   (cond ((typep (formula-slot2 form) 'boolean)
		  (setf (formula-slot1 form) 
			(not (formula-slot2 form)))
		  (formula-slot2 form))
		 ((and (eq (car shares) 'share)
;;		       (consp (cdr (formula-slot2 form))))
		       (not (single-lit-clausesp (formula-slot2 form)))
		       (or (not *or-parp*)
			   (cdr shares)))
;; 		       (or (consp (cdr (formula-slot2 form)))
;; 			   (not (list-limit (first (formula-slot2 form)) 20))))
		  (lit-for-form- form)))
;; 	   (when (and (integerp (formula-slot1 form))
;; 		      (> (formula-slot1 form) 0))
;; 	     (comp+ form))
;;	   (when (typep (formula-slot2 form) 'boolean) (break))
;;	   (format t "comp-:~%  form: ~A~%  clauses: ~A~%~%" form (formula-slot2 form))
	   (formula-slot2 form)))))

;; (declaim (ftype (function (formula boolean) (or clause-list (eql t))) comp))
;; (defun comp (form pol)
;;   (if pol (comp+ form) (comp- form)))

(defun simplify-clause (c fhash)
  (if *mergingp*
      (values (clause-ltree c) (clause-len c))
    (let ((nc (sort (copy-list (flatten-clause c fhash)) #'< :key #'cnf-lit-order-val))
	  (last 0))
      (loop for lit in nc
	    when (eq last (cnf-lit-neg lit)) return (values t 0)
	    unless (eq last lit)
	    collect lit into lits
	    and count lit into lcount
	    and do (setf last lit)
	    finally (return (values lits lcount))))))

(defun add-simplified-clause (c cs)
  (cond ((eq c t) cs)
	((eq cs t) (list c))
	(t (cons c cs))))

(defun simplify-clauses-aux (ndef cs ncs ccount lcount fhash)
  (if (endp cs)
      (values ncs ccount lcount)
    (multiple-value-bind
	(nc lc)
	(simplify-clause (first cs) fhash)
      (multiple-value-bind
	  (ncs ccount lcount)
	  (simplify-clauses-aux ndef (rest cs) (add-simplified-clause nc ncs)
				(if (eq nc t) ccount (1+ ccount)) (+ lc lcount) fhash)
	(if (eq nc t)
	    (values ncs ccount lcount)
	  (dolist (lit nc (values ncs ccount lcount))
	    (unless (or (cnf-lit-appears lit)
			(eq ndef lit))
	      (setf (cnf-lit-appears lit) t)
	      (when (cnf-var-intermediatep (cnf-lit-var lit))
		(setf (values ncs ccount lcount)
		      (simplify-clauses-aux (cnf-lit-neg lit)
					    (clause-list-clauses (cnf-lit-implies lit))
					    ncs ccount lcount fhash))))))))))

(defun simplify-clauses (clauses)
  (simplify-clauses-aux nil clauses t 0 0 (make-hash-table :test 'eq :size 10000)))

(defun number-vars (vars)
  (setf *counter* 0)
;;;  (print (mapcar (lambda (x) (cons x (slc-get-lit (formula-slot1 x)))) vars))
  (loop for var in vars
	for cnf-var = (if (formula-slot1 var)
			  (cnf-lit-var (slc-get-lit (formula-slot1 var)))
			nil)
	when (and cnf-var
		  (or (cnf-lit-appears (cnf-var-lit+ cnf-var))
		      (cnf-lit-appears (cnf-var-lit- cnf-var))))
	  do (incf *counter*)
	  and collect (cons var *counter*) into vlist
	  and do (setf (cnf-var-num cnf-var) *counter*) 
	finally (return (let ((varray (make-array (1+ *counter*))))
			  (dolist (vpair vlist varray)
			    (setf (aref varray (cdr vpair))
				  (car vpair)))))))

(defun lits-to-numbers-clause (c)
  (when (and (consp c)
	     (not (integerp (first c))))
    (let* ((lit (first c))
	   (var (cnf-lit-var lit)))
      (when (= (cnf-var-num var) 0)
	(setf (cnf-var-num var) (incf *counter*)))
      (setf (first c)
	    (if (cnf-lit-pol lit)
		(cnf-var-num var)	      
	      (- (cnf-var-num var))))
      (lits-to-numbers-clause (rest c)))))
      
(defun lits-to-numbers (cs)
  (dolist (c cs cs) (lits-to-numbers-clause c)))

(defun mv-cnf (form vars)
;;;  (format t "vars: ~A~%" vars)
  (let* ((form (if *df* (deflatten form) form))
	 (form (if *if* form (remove-ifs form)))
	 (form (if (member *ap* '(cnf t)) (and-propagation form) form))
;;	 (form (nice-to-aig form))
	 (form (if *lp* (linearize form) form))
	 (form (if *metap* (nice-to-aig+meta form) (nice-to-aig form)))
;;;	 (form (add-redundancies form))
;;;	 (vars (vars-in-form form))
;;	 (vhash (make-hash-table :test 'eq :size (length vars)))
	 )
    (cond ((eq form *one*) (values t nil 0 0 0))
	  ((eq form *zero*) (values nil nil 0 0 0))
	  (t
	   (label-shares form)
	   (clrhash *fhash*)
	   (setf *ftrie* nil)
	   (setf *order-val* 0)
	   (let ((clauses (comp+ form)))
	     (cond ((eq clauses nil) (values nil nil 0 0 0))
		   ((eq clauses t) (values t nil 0 0 0))
		   (t
		    (multiple-value-bind
			(clauses ccount lcount)
			(simplify-clauses (clause-list-clauses clauses))
;; 		      (dolist (clause clauses (print nil))
;; 			(dolist (lit clause)
;; 			  (when (eq (first (formula-args (cnf-var-form (cnf-lit-var lit)))) '_T0)
;; 			    (return (print t)))))
		      (cond ((eq clauses nil) (values nil nil 0 0 0))
			    ((eq clauses t)   (values t   nil 0 0 0))
			    (t
			     (let ((varray (number-vars vars)))
			       (values (lits-to-numbers clauses)
				       varray *counter* ccount lcount))))))))))))


;; 	   (used-vars form vhash)
;; 	   (clear-slot1 form)
;; 	   (setf *counter* 0)
;; 	   (count-shares-with-pol form)
;; 	   (clrhash *fhash*)
;; 	   (setf *ftrie* nil)
;; 	   (let* ((varray (comp-vars vhash vars))
;; 		  (clauses (comp+ form)))
;; 	     (clear-both-slots form)
;; 	     (shed-extra-args form)
;; 	     (values (clause-list-clauses (append-clause-lists *sforms* clauses)) varray))))))


;;     (multiple-value-bind
;; 	(ncs ccount lcount)
;; 	(simplify-clauses-aux (rest cs) ncs ccount lcount)



;;   (loop with fhash = (make-hash-table :test 'eq :size 10000)
;; 	for c in cs
;; 	for (sc . lcount) = (multiple-value-bind
;; 				(sc1 sc2)
;; 				(simplify-clause c fhash)
;; 			      (cons sc1 sc2))
;; 	unless (atom sc)
;; 	  sum lcount into lsum
;; 	  and collect sc into scs
;; 	  and count c into ccount
;; 	  and do (loop for lit in sc do
		       
;; 	finally (return (values scs ccount lsum))))




(defun comp-vars (vhash vars)
  (let ((varray (make-array (1+ (hash-table-count vhash))
			    :element-type 'formula 
			    :initial-element (make-formula))))
    (dolist (var vars varray)
      (when (gethash var vhash)
	(incf *counter*)
	(setf (formula-slot1 var) (clauses-for-lit *counter*))
	(setf (formula-slot2 var) (clauses-for-lit (- *counter*)))
	(setf (aref varray *counter*) var)))))

;; (defun shed-extra-args-aux (form)
;;   (when (and (formula-p form)
;; 	     (not (formula-slot1 form)))
;;     (setf (formula-slot1 form) t)
;;     (case (formula-fn form)
;;       (<-> (setf (cddr (formula-args form)) nil))
;;       (if  (setf (cdddr (formula-args form)) nil)))
;;     (dolist (arg (formula-args form)) (shed-extra-args-aux arg)))
;;   nil)

;; (defun shed-extra-args (form)
;;   (shed-extra-args-aux form)
;;   (clear-slot1 form)
;;   nil)

;; (declaim (ftype (function (formula list)
;; 			  (values (or boolean cons)
;; 				  (or (array formula) null)))
;; 		mv-cnf))
;; (defun mv-cnf (form vars)
;; ;;;  (format t "vars: ~A~%" vars)
;;   (let* ((form (if *df* (deflatten form) form))
;; 	 (form (if *if* form (remove-ifs form)))
;; 	 (form (if (member *ap* '(cnf t)) (and-propagation form) form))
;; 	 (form (if *lp* (linearize form) form))
;; ;;;	 (form (add-redundancies form))
;; ;;;	 (vars (vars-in-form form))
;; 	 (vhash (make-hash-table :test 'eq :size (length vars))))
;;     (cond ((eq form *one*) (values t nil))
;; 	  ((eq form *zero*) (values nil nil))
;; 	  (t
;; 	   (used-vars form vhash)
;; 	   (clear-slot1 form)
;; 	   (setf *counter* 0)
;; 	   (count-shares-with-pol form)
;; 	   (clrhash *fhash*)
;; 	   (setf *ftrie* nil)
;; 	   (let* ((varray (comp-vars vhash vars))
;; 		  (clauses (comp+ form)))
;; 	     (clear-both-slots form)
;; 	     (shed-extra-args form)
;; 	     (values (clause-list-clauses (append-clause-lists *sforms* clauses)) varray))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; tseitin + nnf                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun nnf-or-form (args)
  (make-unique-formula :fn 'or
		       :args args))

(defun nnf- (form )
  (if (formula-slot2 form)
      (formula-slot2 form)
    (setf (formula-slot2 form)
	  (case (formula-fn form)
	    (var (sb-not-form form))
	    (not (nnf+ (first (formula-args form))))
	    (and (nnf-or-form (mapcar #'nnf- (formula-args form))))
	    (if (let* ((args (formula-args form))
		       (arg1 (first args))
		       (arg2 (second args))
		       (arg3 (third args)))
		  (sb-and-form (list (nnf-or-form (list (nnf- arg1) (nnf- arg2)))
				     (nnf-or-form (list (nnf+ arg1) (nnf- arg3)))))))
	    (<-> (let* ((args (formula-args form))
			(arg1 (first args))
			(arg2 (second args)))
		   (sb-and-form (list (nnf-or-form (list (nnf- arg1) (nnf- arg2)))
				      (nnf-or-form (list (nnf+ arg1) (nnf+ arg2)))))))
	    (otherwise (break (format nil "nnf-: unexpected function: ~A" (formula-fn form))))))))

(defun nnf+ (form)
  (if (formula-slot1 form)
      (formula-slot1 form)
    (setf (formula-slot1 form)
	  (case (formula-fn form)
	    (var form)
	    (not (nnf- (first (formula-args form))))
	    (and (sb-and-form (mapcar #'nnf+ (formula-args form))))
	    (if (let* ((args (formula-args form))
		       (arg1 (first args))
		       (arg2 (second args))
		       (arg3 (third args)))
		  (sb-and-form (list (nnf-or-form (list (nnf- arg1) (nnf+ arg2)))
				     (nnf-or-form (list (nnf+ arg1) (nnf+ arg3)))))))
	    (<-> (let* ((args (formula-args form))
			(arg1 (first args))
			(arg2 (second args)))
		   (sb-and-form (list (nnf-or-form (list (nnf- arg1) (nnf+ arg2)))
				      (nnf-or-form (list (nnf+ arg1) (nnf- arg2)))))))
	    (otherwise (break (format nil "nnf+: unexpected function: ~A" (formula-fn form))))))))

(defun nnf (form) 
  (let ((nform (nnf+ form)))
    (clear-both-slots form)
    nform))

;; (defun nice-to-aig-if-aux (lst1 tail)
;;   (if (endp lst1)
;;       tail
;;     (cons 

;; (defun nice-to-aig-if (form)
;;   (cond ((not (eq (formula-fn form) 'if))
;; 	 (list (nice-to-aig form)))
;; 	((formula-slot2 form)
;; 	 (formula-slot2 form))
;; 	(t
;; 	 (let* ((args (formula-arsg form))
;; 		(test (nice-to-aig (first args)))
;; 		(pl (nice-to-aig-if (second args)))
;; 		(nl (nice-to-aig-if (third args))))
;; 	   (

;;   (if (eq (formula-fn form) 'if)
;;       (let* ((args (formula-args form))
;; 	     (test (nice-to-aig (first args))))
;; 	(nice-to-aig-if-aux (third args)
;; 			    (cons test tests)
;; 			    (nice-to-aig-if-aux (second args)
;; 						(cons (sb-not-form test)
;; 						      tests)
;; 						acc)))
;;     (sb-or-form (cons (nice-to-aig form) tests))))

(defun nice-to-aig-aux (form)
  (if (formula-slot1 form)
      (formula-slot1 form)
    (setf (formula-slot1 form)
	  (case (formula-fn form)
	    (var form)
	    (not (sb-not-form (nice-to-aig-aux (first (formula-args form)))))
	    (and (sb-and-form (mapcar #'nice-to-aig-aux (formula-args form))))
	    (if (let* ((args (formula-args form))
		       (arg1 (nice-to-aig-aux (first args)))
		       (arg2 (nice-to-aig-aux (second args)))
		       (arg3 (nice-to-aig-aux (third args))))
		  (sb-and-form (list (sb-or-form (list (sb-not-form arg1) arg2))
				     (sb-or-form (list arg1 arg3))))))
	    (<-> (let* ((args (formula-args form))
			(arg1 (nice-to-aig-aux (first args)))
			(arg2 (nice-to-aig-aux (second args))))
		   (sb-and-form (list (sb-or-form (list (sb-not-form arg1) arg2))
				      (sb-or-form (list arg1 (sb-not-form arg2)))))))
	    (otherwise (break (format nil "nice-to-aig-aux: unexpected function: ~A" (formula-fn form))))))))

(defun nice-to-aig (form)
  (let ((nform (nice-to-aig-aux form)))
    (clear-slot1 form)
    nform))


(declaim (ftype (function (t) null) ts-count-shares+))
(defun ts-count-shares+ (form)
  (when (formula-p form)
    (cond ((eq (formula-fn form) 'not) (ts-count-shares- (first (formula-args form))))
	  ((not (eq (formula-slot1 form) 'share))
	   (when (eq (formula-slot1 form) 'dna)
	     (dolist (arg (formula-args form)) (ts-count-shares+ arg)))
	   (when (eq (formula-slot2 form) 'noshare)
	     (setf (formula-slot2 form) 'share))
	   (if (or (not (eq (formula-slot2 form) 'dna))
		   (eq (formula-slot1 form) 'noshare))
	       (setf (formula-slot1 form) 'share)
	     (setf (formula-slot1 form) 'noshare)))))
  nil)

;; (defun ts-count-shares+ (form)
;;   (when (formula-p form)
;;     (cond ((eq (formula-fn form) 'not) (ts-count-shares- (first (formula-args form))))
;; 	  ((null (formula-slot1 form))
;; 	   (setf (formula-slot1 form) (if (formula-slot2 form) 'share 'noshare))
;; 	   (dolist (arg (formula-args form)) (ts-count-shares+ arg)))
;; 	  ((eq (formula-slot1 form) 'noshare)
;; 	   (setf (formula-slot1 form) 'share)
;; 	   (when (eq (formula-slot2 form) 'noshare)
;; 	     (setf (formula-slot2 form) 'share))))
;;     nil))

(declaim (ftype (function (t) null) ts-count-shares-))
;; (defun ts-count-shares- (form)
;;   (when (formula-p form)
;;     (cond ((eq (formula-fn form) 'not) (ts-count-shares+ (first (formula-args form))))
;; 	  ((null (formula-slot2 form))
;; 	   (setf (formula-slot2 form) (if (formula-slot1 form) 'share 'noshare))
;; 	   (dolist (arg (formula-args form)) (ts-count-shares- arg)))
;; 	  ((eq (formula-slot2 form) 'noshare)
;; 	   (setf (formula-slot2 form) 'share)
;; 	   (when (eq (formula-slot1 form) 'noshare)
;; 	     (setf (formula-slot1 form) 'share))))
;;     nil))

(defun ts-count-shares- (form)
  (when (formula-p form)
    (cond ((eq (formula-fn form) 'not) (ts-count-shares+ (first (formula-args form))))
	  ((not (eq (formula-slot2 form) 'share))
	   (when (eq (formula-slot2 form) 'dna)
	     (dolist (arg (formula-args form)) (ts-count-shares- arg)))
	   (when (eq (formula-slot1 form) 'noshare)
	     (setf (formula-slot1 form) 'share))
	   (if (or (not (eq (formula-slot1 form) 'dna))
		   (eq (formula-slot2 form) 'noshare))
	       (setf (formula-slot2 form) 'share)
	     (setf (formula-slot2 form) 'noshare)))))
  nil)

(defun ts-count-shares-aux (form)
  (when (and (formula-p form)
	     (not (formula-slot1 form)))
    (setf (formula-slot1 form)
	  (setf (formula-slot2 form)
		'dna))
    (dolist (arg (formula-args form))
      (ts-count-shares-aux arg))))

(declaim (ftype (function (t) null) ts-count-shares-))
(defun ts-count-shares (form)
  (ts-count-shares-aux form)
  (ts-count-shares+ form))

(defun var-for-form (form)
  (if (eq (formula-fn form) 'not)
      (var-for-form (first (formula-args form)))
    (let* ((var (incf *counter*))
	   (ncl (clauses-for-lit (- var)))
	   (pcl (clauses-for-lit var)))
      (setf *sforms*
	    (append-clause-lists (or-clauses ncl
					     (ts-clauses+ form))
				 (or-clauses pcl
					     (ts-clauses- form))
				 *sforms*))
      (setf (formula-slot1 form) pcl)
      (setf (formula-slot2 form) ncl)))
  *counter*)
			       
(defun ts-clauses+ (form)
  (cond ((eq (formula-fn form) 'not) 
	 (ts-clauses- (first (formula-args form))))
	((typep (formula-slot1 form) '(or boolean clause-list))
	 (formula-slot1 form))
	((eq (formula-fn form) 'and)
	 (setf (formula-slot1 form)
	       (apply #'append-clause-lists (mapcar #'tseitin+ (formula-args form)))))
	(t (break (format nil "ts-clauses+: unexpected function: ~A"
			  (formula-fn form))))))

(defun tseitin+ (form)
  (cond ((eq (formula-fn form) 'not)
	 (tseitin- (first (formula-args form))))
	(t (when (and (eq (formula-slot1 form) 'share)
		      (not (single-lit-clausesp (ts-clauses+ form))))
	     (var-for-form form))
	   (ts-clauses+ form))))
	
(defun ts-disjunction (args acc)
  (if (endp args)
      acc
    (let* ((arg (first args))
	   (arg-cl (tseitin- arg)))
      (ts-disjunction (cdr args)
		      (or-clauses (cond ((single-lit-clausesp arg-cl)
					 arg-cl)
					(t
					 (var-for-form arg)
					 (ts-clauses- arg)))
				  acc)))))
		       
(defun ts-clauses- (form)
  (cond ((eq (formula-fn form) 'not) 
	 (ts-clauses+ (first (formula-args form))))
	((typep (formula-slot2 form) '(or boolean clause-list))
	 (formula-slot2 form))
	((eq (formula-fn form) 'and)
	 (setf (formula-slot2 form)
	       (ts-disjunction (formula-args form) nil)))
	(t (break (format nil "ts-clauses-: unexpected function: ~A"
			  (formula-fn form))))))

(defun tseitin- (form)
  (cond ((eq (formula-fn form) 'not)
	 (tseitin+ (first (formula-args form))))
	(t (when (and (eq (formula-slot2 form) 'share)
		      (not (single-lit-clausesp (ts-clauses- form))))
	     (var-for-form form))
	   (ts-clauses- form))))
	

(defun ts-lit-for-slot (form slota slotb)
  (let* ((sb (funcall slotb form))
	 (lit (if (single-lit-clausesp sb)
		 (- (slc-get-lit sb))
	       (incf *counter*))))
    (setf *sforms*
	  (append-clause-lists (or-clauses (clauses-for-lit (- lit))
					   (funcall slota form))
			       *sforms*))
   (clauses-for-lit lit)))
  
(defun ts-lit-for-form+ (form)
  (ts-lit-for-slot form #'formula-slot1 #'formula-slot2))

(defun ts-lit-for-form- (form)
  (ts-lit-for-slot form #'formula-slot2 #'formula-slot1))
					 
(defun nnf-to-cnf (form)
  (if (formula-slot1 form)
      (formula-slot1 form)
    (setf (formula-slot1 form)
	  (case (formula-fn form)
	    (not (formula-slot2 (first (formula-args form))))
	    (and (mapcar #'nnf-to-cnf (formula-args form))
		 (apply #'append-clause-lists
			(mapcar #'ts-lit-for-form+ (formula-args form))))
	    (or (loop for arg in (formula-args form)
		      for clauses = (nnf-to-cnf arg)
		      when (eq clauses t) return t
		      when clauses collect (ts-lit-for-form+ arg) into clauses-list
		      finally (return (or-clauses-list clauses-list))))
	    (otherwise (break (format nil "nnf-to-cnf: unexpected function: ~A"
				      (formula-fn form))))))))


(defun ts-simplify-clause (c fhash)
  (let ((nc (sort (copy-list (flatten-clause c fhash)) #'< :key #'abs))
	(last 0))
    (loop for lit in nc
	  when (= last (- lit)) return (values t 0)
	  unless (= last lit)
	    collect lit into lits
	    and count lit into lcount
	    and do (setf last lit)
	  finally (return (values lits lcount)))))

(defun ts-simplify-clauses (cs)
  (loop with fhash = (make-hash-table :test 'eq :size 10000)
	for c in cs
	for (sc . lcount) = (multiple-value-bind
				(sc1 sc2)
				(ts-simplify-clause c fhash)
			      (cons sc1 sc2))
	unless (atom sc)
	  sum lcount into lsum
	  and collect sc into scs
	  and count c into ccount
	finally (return (values scs ccount lsum))))

(defun ts-cnf (form vars)
  (let ((form (nice-to-aig form))
	(vhash (make-hash-table :test 'eq :size (length vars))))
    (clrhash *fhash*)
    (setf *ftrie* nil)
    (used-vars form vhash)
    (clear-slot1 form)
    (setf *counter* 0)
    (ts-count-shares form)
    (let ((varray (comp-vars vhash vars))
	  (clauses (tseitin+ form)))
      (clear-both-slots form)
      (multiple-value-bind
	  (scs ccount lcount)
	  (ts-simplify-clauses (clause-list-clauses (append-clause-lists *sforms*
									 clauses)))
	(values scs varray *counter* ccount lcount)))))
;;;     (values (clause-list-clauses (append-clause-lists *sforms* clauses)) varray))))

;; (defun ts-cnf (form vars)
;;   (let ((form (nnf form))
;; 	(vhash (make-hash-table :test 'eq :size (length vars))))
;;     (clrhash *fhash*)
;;     (setf *ftrie* nil)
;;     (used-vars form vhash)
;;     (clear-slot1 form)
;;     (setf *counter* 0)
;;     (let ((varray (comp-vars vhash vars))
;; 	  (clauses (nnf-to-cnf form)))
;;       (clear-both-slots form)
;;       (multiple-value-bind
;; 	  (scs ccount lcount)
;; 	  (ts-simplify-clauses (clause-list-clauses (append-clause-lists *sforms*
;; 									 clauses)))
;; 	(values scs varray *counter* ccount lcount)))))
;; ;;      (values (clause-list-clauses (append-clause-lists *sforms* clauses)) varray))))

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ;;; jackson + sheridan                         ;;;
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; (declaim (ftype (function (t) null) no-pol-count-shares))
;; (defun no-pol-count-shares (form)
;;   (when (formula-p form)
;;     (unless (natp (formula-slot1 form)) (setf (formula-slot1 form) 0))
;;     (when (or (= (formula-slot1 form) 0)
;; 	      (eq (formula-fn form) 'not))
;;       (mapcar #'no-pol-count-shares (formula-args form)))
;;     (incf (formula-slot1 form)))
;;   nil)


;; ;; returns values for the positive and negative values for the form.
;; ;; if the form simplifies to t or nil, returns that value,
;; ;; otherwise sets a variable equal to its value and returns the singleton clauses
;; ;; for the positive and negative polarity of the variable.
;; (declaim (ftype (function (formula) (values (or list (eql t)) (or list (eql t)))) no-pol-new-var-for-form))
;; (defun no-pol-new-var-for-form (form)
;;   (let ((c+ (no-pol-comp+ form))
;; 	(c- (no-pol-comp- form)))
;;     (cond ((or (atom c+)
;; 	       (and (endp (cdar c+))
;; 		    (endp (cdr c+)))
;; 	       (atom c-))
;; 	   (values c+ c-))
;; 	  (t
;; 	   (let ((var (incf *counter*)))
;; 	     (setf *sforms*
;; 		   (append-clause-lists (cart-prod `((,var)) c-)
;; 					(cart-prod `((,(- var))) c+)
;; 					*sforms*))
;; 	     (values `((,var)) `((,(- var)))))))))


;; ;args should already have had comp run on them. clengths is the
;; ;lengths of the negated clauses of the args everything should be
;; ;sorted so that the args are in decreasing order of their clengths,
;; ;and the clengths are also in decreasing order. this isn't quite the
;; ;same as in the paper, where they assume and is binary. so, we pull a
;; ;trick by using the sorted list and picking out the biggest thing each
;; ;time.
;; (declaim (ftype (function (list list integer integer) (or list (eql t))) no-pol-dis-clauses1))
;; (defun no-pol-dis-clauses1 (args clengths csum cprod)
;;   ;; (format t "~&no-pol-dis-clauses1~%")
;;   (if (<= cprod csum) 
;;       (cart-prod-list (mapcar #'no-pol-comp- args))
;;     (multiple-value-bind
;; 	(pv nv)
;; 	(no-pol-new-var-for-form (car args))
;;       (if pv
;; 	  (let ((dcr (no-pol-dis-clauses1 (cdr args) 
;; 					  (cdr clengths) 
;; 					  (- csum (- (car clengths) 1))
;; 					  (/ cprod (car clengths)))))
;; 	    (cond ((atom pv) dcr) ;; pv is true, so nv is false, so dcr is the answer.
;; 		  ((not dcr) nv) ;; dcr is false, so nv is the answer.
;; 		  ((atom dcr) t) ;; dcr is true, so must be true.
;; 		  (t
;; 		   (cart-prod nv dcr)))) ;; neither are true or false, so or them together.
;; 	t))))

;; (declaim (ftype (function (list list) (values list (or list (eql t)))) no-pol-clauseinfo))
;; (defun no-pol-clauseinfo (args acc)
;;   (if (endp args)
;;       (let ((ci (sort acc #'> :key #'car)))
;; 	(loop for i in ci
;; 	      collect (car i) into cari
;; 	      collect (cdr i) into cdri
;; 	      finally (return (values cari cdri))))
;;     (let* ((arg (car args))
;; 	   (clauses (no-pol-comp- arg)))
;;       (cond ((consp clauses)
;; 	     (no-pol-clauseinfo (cdr args)
;; 				(acons (length (no-pol-comp- arg)) arg acc)))
;; 	    (clauses (values nil t))
;; 	    (t (no-pol-clauseinfo (cdr args) acc))))))

;; ;; forms the disjunction of the clauses of the forms of args
;; (declaim (ftype (function (list) (or list (eql t))) no-pol-dis-clauses))
;; (defun no-pol-dis-clauses (args)
;;   (multiple-value-bind
;;       (clengths nargs)
;;       (no-pol-clauseinfo args nil)
;;     (if (atom nargs)
;; 	nargs
;;       (no-pol-dis-clauses1 nargs clengths 
;; 			   (apply #'+ clengths)
;; 			   (apply #'* clengths)))))

;; (declaim (ftype (function (list) formula) no-pol-comp-and-form))
;; (defun no-pol-comp-and-form (args)
;;   (make-formula :fn 'and
;; 		:slot1 1
;; 		:args args))

;; (declaim (ftype (function (formula) formula) no-pol-comp-not-form))
;; (defun no-pol-comp-not-form (arg)
;;   (if (eq (formula-fn arg) 'not)
;;       (car (formula-args arg))
;;     (make-formula :fn 'not 
;; 		  :slot1 1 
;; 		  :args (list arg))))

;; (declaim (ftype (function (list) formula) no-pol-comp-or-form))
;; (defun no-pol-comp-or-form (args)
;;   (no-pol-comp-not-form (no-pol-comp-and-form (mapcar #'no-pol-comp-not-form args))))

;; ;no-pol-comp with positive polarity
;; (declaim (ftype (function (formula) (or list (eql t))) no-pol-comp+))
;; (defun no-pol-comp+ (form)
;;   (cond ((not (natp (formula-slot1 form))) 
;; 	 (formula-slot1 form))
;;         (t
;; 	 ;; (format t " recursive")
;;          (let ((shares (formula-slot1 form)))
;;            (setf (formula-slot1 form)
;; 		 (case (formula-fn form)
;; 		   (and (apply #'append-clause-lists 
;; 			       (mapcar #'no-pol-comp+ (formula-args form))))
;; 		   (not (no-pol-comp- (car (formula-args form))))
;; 		   (<-> (let* ((args (formula-args form))
;; 			       (arg1 (first args))
;; 			       (arg2 (second args)))
;; 			  (no-pol-comp+ (no-pol-comp-and-form (list (no-pol-comp-or-form (list arg1
;; 											       (no-pol-comp-not-form arg2)))
;; 								    (no-pol-comp-or-form (list (no-pol-comp-not-form arg1) 
;; 											       arg2)))))))
;; 		   (if (let* ((args (formula-args form))
;; 			      (ifexp (first args)))
;; 			 (no-pol-comp+ (no-pol-comp-and-form (list (no-pol-comp-or-form (list (no-pol-comp-not-form ifexp)
;; 											      (second args)))
;; 								   (no-pol-comp-or-form (list ifexp
;; 											      (third args))))))))
;; 		   (otherwise (format t "no-pol-comp+: unexpected function: ~A~%" form))))
;; 	   (cond ((atom (formula-slot1 form))
;; 		  (setf (formula-slot2 form) 
;; 			(not (formula-slot1 form)))
;; 		  (formula-slot1 form))
;; 		 ((or (<= shares 1)
;; 		      (endp (cdr (formula-slot1 form))))
;; 		  (formula-slot1 form))
;; 		 (t
;; 		  (multiple-value-bind
;; 		      (pv nv)
;; 		      (no-pol-new-var-for-form form)
;; 		    (setf (formula-slot2 form) nv)
;; 		    (setf (formula-slot1 form) pv))))))))

;; ;no-pol-comp with negative polarity
;; (declaim (ftype (function (formula) (or list (eql t))) no-pol-comp-))
;; (defun no-pol-comp- (form)
;;   ;; (format t "~&no-pol-comp-: slot1: ~A slot2: ~A~%" (formula-slot1 form) (formula-slot2 form))
;;   (cond ((or (formula-slot2 form)
;; 	     (eq (formula-slot1 form) t))
;; 	 (formula-slot2 form))
;;         (t
;; 	 ;; (format t " recursive")
;;          (let ((shares (if (natp (formula-slot1 form)) (formula-slot1 form) 1)))
;;            (setf (formula-slot2 form)
;; 		 (case (formula-fn form)
;; 		   (and (no-pol-dis-clauses (formula-args form)))
;; 		   (not (no-pol-comp+ (car (formula-args form))))
;; 		   (<-> (let* ((args (formula-args form))
;; 			       (arg1 (first args))
;; 			       (arg2 (second args)))
;; 			  (no-pol-comp+ (no-pol-comp-and-form (list (no-pol-comp-or-form (list (no-pol-comp-not-form arg1) 
;; 											       (no-pol-comp-not-form arg2)))
;; 								    (no-pol-comp-or-form (list arg1 arg2)))))))
;; 		   (if (let* ((args (formula-args form))
;; 			      (ifexp (first args)))
;; 			 (no-pol-comp+ (no-pol-comp-and-form (list (no-pol-comp-or-form (list (no-pol-comp-not-form ifexp)
;; 											      (no-pol-comp-not-form (second args))))
;; 								   (no-pol-comp-or-form (list ifexp
;; 											      (no-pol-comp-not-form (third args)))))))))
;; 		   (otherwise (format t "no-pol-comp-: unexpected function: ~A~%" form) (break))))
;; 	   (cond ((atom (formula-slot2 form))
;; 		  (setf (formula-slot1 form) 
;; 			(not (formula-slot2 form)))
;; 		  (formula-slot2 form))
;; 		 ((or (<= shares 1)
;; 		      (endp (cdr (formula-slot2 form))))
;; 		  (formula-slot2 form))
;; 		 (t
;; 		  (multiple-value-bind
;; 		      (pv nv)
;; 		      (no-pol-new-var-for-form form)
;; 		    (setf (formula-slot1 form) pv)
;; 		    (setf (formula-slot2 form) nv))))))))

;; (defun js-cnf (form vars)
;;   (let ((form (linearize (remove-ifs form)))
;; 	(vhash (make-hash-table :test 'eq :size (* 2 (length vars)))))
;;     (clrhash *fhash*)
;;     (setf *ftrie* nil)
;;     (used-vars form vhash)
;;     (clear-slot1 form)
;;     (setf *counter* 0)
;;     (count-shares form)
;;     (let* ((varray (comp-vars vhash vars))
;; 	   (clauses (comp+ form)))
;;       (clear-both-slots form)
;;       (values (append-clause-lists *sforms* clauses) varray))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; end cnf-translations                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(declaim (ftype (function (formula hash-table) null) used-vars))
(defun used-vars (form hash)
  (when (and (formula-p form)
	     (not (formula-slot1 form)))
    (if (eq (formula-fn form) 'var)
	(setf (gethash form hash) (incf *counter*))
      (mapcar #'(lambda (x) (used-vars x hash))
	      (formula-args form)))
    (setf (formula-slot1 form) t)
    nil))

(defun sortvars (vars ovars)
  (let ((vhash (make-hash-table :test 'eq :size (length vars)))
	(n 0))
    (dolist (ovar ovars)
      (let ((name (first ovar)))
	(setf (gethash name vhash) (incf n))))
    (dolist (var vars)
      (let* ((name (first (formula-args var)))
	     (val  (gethash name vhash)))
	(unless val (setf (gethash name vhash) (incf n)))))
    (sort vars
	  (lambda (v1 v2)
	    (let* ((args1 (formula-args v1))
		   (name1 (gethash (first args1) vhash))
		   (step1 (second args1))
		   (bit1  (third args1))
		   (args2 (formula-args v2))
		   (name2 (gethash (first args2) vhash))
		   (step2 (second args2))
		   (bit2  (third args2)))
	      (or (< step1 step2)
		  (and (= step1 step2)
		       (or (< name1 name2)
			   (and (= name1 name2)
				(< bit1 bit2))))))))))

;; (declaim (ftype (function (formula list list)
;; 			  (values (or list boolean)
;; 				  (or (array formula) null)))
;; 		cnf))
(defun cnf (form vars ovars)
  (let* ((vars (sortvars vars ovars)))
;;    (mv-cnf form vars)))
    (case *cnf*
      (mv (mv-cnf form vars))
      (ts (ts-cnf form vars)))))
  
;;     (count-shares-with-pol form)
;;       (let ((clauses (comp+ form)))
;; 	(clear-both-slots form)
;; 	(values (append-clause-lists *sforms* clauses) varray))))

;prints the cnf form of the formula form over variables vars into file filename.
;returns the array of variables. varray[i] is the ith cnf variable.
(declaim (ftype (function (list array (or symbol string) boolean fixnum fixnum fixnum)
			  null)
		print-comp-cnf))
(defun print-comp-cnf (clauses varray filename ld? vcount ccount lcount)
  (let ((d (array-dimension varray 0)))
    (with-open-file (stream (if ld?
				(format nil "~A.cnf" filename)
			      (format nil "~A.cnf" filename))
 			    :direction :output
 			    :if-exists :supersede
 			    :if-does-not-exist :create)
      (dotimes (i d)
	(unless (= i 0)
	  (format stream "c ~D = ~A~%" i (aref varray i))))
      (format stream "p cnf ~D ~D~%" vcount ccount)
      (format t "~&vars: ~D clauses: ~D literals: ~D~%"
	      vcount ccount lcount)
      (format stream "~{~{~D ~}0~%~}" clauses)
      #|(format stream "~{~{~D ~}0~%~}" clauses)|#)))

(declaim (ftype (function (string list string) null) generic run))
(defun generic-run (command inputs output)
#+allegro
  (if output  
      (run-shell-command (format nil "~A ~{ ~A~} > ~A" command inputs output))
    (run-shell-command (format nil "~A ~{ ~A~}" command inputs)))
#+(or mcl cmu sbcl)
  (if output
      (run-program command inputs :output output :if-output-exists :supersede)
    (run-program command inputs))
  nil)
	       
(declaim (ftype (function ((or symbol string)) null) run-satelite))
(defun run-satelite (filenamebase)
  (declare (special *satelite*))
  (generic-run *satelite*
	       (list (format nil "~A.cnf" filenamebase)
		     "+pre"
		     "+ve+"
		     "verbosity=0"
		     (format nil "~A-RED.cnf" filenamebase)
		     (format nil "~A.vmap" filenamebase)
		     (format nil "~A.elim" filenamebase))
	       nil))

(declaim (ftype (function (string fixnum (or string symbol)) (or boolean (array boolean))) solve-zchaff))
(defun solve-zchaff (zchaff nv filename)
  (generic-run zchaff (list (format nil "~A.cnf" filename)) (format nil "~A.out" filename))
  (with-open-file (stream (format nil "~A.out" filename) :direction :input)
    (let ((line ""))
      (loop until (and (> (length line) 8)
		       (string= line "Instance" :end1 8)) do
	(setf line (read-line stream)))
      (cond ((and (> (length line) 21)
		  (string= line "Instance Unsatisfiable" :end1 22))
	     nil)
	    (t
	     (let ((vals (make-array (1+ nv)
				     :element-type 'boolean
				     :initial-element nil)))
	       (loop for i from 1 to nv do
		     (let ((v (read stream)))
		       (setf (aref vals i) (< 0 v))))
	       vals))))))

(declaim (ftype (function (string fixnum (or string symbol)) (or boolean (array boolean))) solve-minisat))
(defun solve-minisat (minisat nv filename)
  (generic-run minisat (list (format nil "~A.cnf" filename) (format nil "~A.out" filename)) nil)
  (with-open-file (stream (format nil "~A.out" filename) :direction :input)
    (let ((line (read-line stream)))
      (when (and (>= (length line) 3)
	       (string= line "SAT" :end1 3))
	(let ((vals (make-array (1+ nv)
				:element-type 'boolean
				:initial-element nil)))
	  (loop for i from 1 to nv do
		(let ((v (read stream)))
		  (setf (aref vals i) (< 0 v))))
	  vals)))))

(declaim (ftype (function (string fixnum (or string symbol))
			  (or boolean (array boolean))) solve-siege))
(defun solve-siege (siege nv filename)
  (generic-run "rm" (list "-f" "siege.results") nil)
  (generic-run siege (list (format nil "~A.cnf" filename)) (format nil "~A.out" filename))
  (with-open-file (stream "siege.results" :direction :input)
    (loop until (char= (read-char stream) #\,))
    (case (read stream)
      (unsatisfiable nil)
      ({ (let ((vals (make-array (1+ nv)
				 :element-type 'boolean
				 :initial-element nil)))
	   (loop for i from 1 to nv do
		 (let ((v (read stream)))
		   (setf (aref vals i) (< 0 v))))
	   vals))
      (otherwise (break "unrecognized siege output")))))

(defun read-satelite-results (filename nv)
  (with-open-file (stream (format nil "~A.out" filename) :direction :input)
    (let ((line (read-line stream)))
      (when (and (>= (length line) 5)
	       (string= line "s SAT" :end1 5))
	(read stream)
	(let ((vals (make-array (1+ nv)
				:element-type 'boolean
				:initial-element nil)))
	  (loop for i from 1 to nv do
		(let ((v (read stream)))
		  (setf (aref vals i) (< 0 v))))
	  vals)))))

(defun cnf-num-vars (file)
  (with-open-file (stream (format nil "~A" file)
			  :direction :input)
    (loop until (eq (read stream) 'p)
	  do (read-line stream)
	  finally (progn (read stream)
			 (return (read stream))))))

(defun solve (solver filename)
  (if *sp*
      (let ((rname (format nil "~A-RED" filename)))
	(format t "~&running satelite.~%")
	(run-satelite filename)
	(if (not (probe-file (format nil "~A.cnf" rname)))
	    (values nil t)
	  (let ((nv (cnf-num-vars (format nil "~A.cnf" rname))))
	    (cond ((= nv 0)
		   (values t t))
		  ((eq solver :none)
		   (format t "~&Original CNF written to ~A.cnf~%" filename)
		   (format t "CNF file resulting from SatELite written to ~A.cnf~%" rname)
		   (values nil nil))
		  (t 
		   (let ((solution (case solver
				     (:zchaff (solve-zchaff *zchaff* nv rname))
				     (:siege  (solve-siege  *siege* nv rname))
				     (:minisat (solve-minisat *minisat* nv rname)))))
		     (when solution
		       (with-open-file (stream (format nil "~A.result" filename)
					       :direction :output
					       :if-exists :supersede
					       :if-does-not-exist :create)
			 (format stream "SAT~%")
			 (loop for i from 1 to (1- (array-dimension solution 0))
			       do (format stream "~A " (if (aref solution i) i (- i)))
			       finally (format stream "0~%")))
		       (generic-run *satelite*
				    (list "+ext"
					  (format nil "~A.cnf" filename)
					  (format nil "~A.result" filename)
					  (format nil "~A.vmap" filename)
					  (format nil "~A.elim" filename))
				    (format nil "~A.out" filename))
			 (values (read-satelite-results filename *counter*) nil))))))))
	  (values (case solver
		    (:zchaff (solve-zchaff *zchaff* *counter* filename))
		    (:siege (solve-siege *siege* *counter* filename))
		    (:minisat (solve-minisat *minisat* *counter* filename)))
		  nil)))

(declaim (ftype (function (form-vec-mem) form-vec-mem) instantiate))
(defun instantiate (form)
  (cond ((mem-p form) (let* ((nw (mem-num-words form))
			     (ws (mem-wordsize form))
			     (nmem (new-mem nw ws)))
			(dotimes (i nw nmem)
			  (dotimes (j ws)
			    (mem-set-bit nmem i j (instantiate (mem-get-bit form i j)))))))
	((vec-p form) (let* ((vb (vec-num-bits form))
			     (nv (new-vec vb)))
			(dotimes (i vb nv)
			  (vec-set-bit nv i (instantiate (vec-get-bit form i))))))
	((eq (formula-fn form) 'const) form)
	((formula-slot1 form) 
	 (formula-slot1 form))
	((eq (formula-fn form) 'var) *zero*)
	(t (setf (formula-slot1 form)
		 (simplify1-step (formula-fn form)
				 (formula-type form)
				 (mapcar #'instantiate (formula-args form))
				 nil nil nil)))))

(declaim (ftype (function (mem list) form-vec) cnf-simplify-get))
(defun cnf-simplify-get (mem cv-pairs)
  (dolist (cv cv-pairs (progn (break) *junk*))
    (when (eq (instantiate (car cv)) *one*)
      (return (mem-get-word mem (cdr cv))))))

(declaim (ftype (function ((array boolean) array list list fixnum) null) print-results)) 
(defun print-results (vals varray vdefs mac-alist steps)
  (let* ((sz (length vdefs))
	 (vhash (make-hash-table :size sz))
	 (mems nil))
    (loop for i from 1 below (array-dimension varray 0)
	  do (setf (formula-slot1 (aref varray i))
		   (if (aref vals i) *one* *zero*))
	  #|do (format t "~A = ~A~%" (aref varray i) (aref vals i))|#)
    (dolist (vdef vdefs nil)
      (cond ((eq (second vdef) 'mem)
	     (let ((mem (make-array (1+ steps)
				    :element-type 'list
				    :initial-element nil)))
	       (dotimes (i (1+ steps) (setf mems (acons (first vdef) mem mems)))
		 ;; (format t "~&mem: ~A step: ~A" (first vdef) i)
		 (let ((val (cdr (assoc (cons (first vdef) i)
					 mac-alist
					 :test 'equal))))
		   (when val
		     (let ((m (instantiate (car val)))
			   (ac (cdr val))
			   (nmemi nil))
		       ;;(format t "~%(car val): ~A~% m: ~A~%" (car val) m)
		       (maphash (lambda (a c)
				  (let ((na (instantiate a)))
				    (unless (assoc na nmemi :test 'eq)
				      (setf nmemi
					    (acons na
						   (cnf-simplify-get m c)
						   nmemi)))))
				ac)
		       (setf (aref mem i) nmemi)))))))
	    (t
	     (setf (gethash (first vdef) vhash)
		   (make-array (list (1+ steps) (type-bits (cdr vdef))) 
			       :element-type 'bit 
			       :initial-element 0)))))
    (loop for i from 1 to (1- (array-dimension varray 0)) do
	  (when (eq (formula-slot1 (aref varray i)) *one*)
	    (let* ((sbv (formula-args (aref varray i)))
		   (var (first sbv))
		   (step (second sbv))
		   (bit (third sbv)))
	      ;; (format t "var ~A~%" var)
	      (multiple-value-bind
		  (a found?)
		  (gethash var vhash)
		(when found?
		  (setf (aref a step bit) 1))))))
    (dotimes (i (1+ steps) nil)
      (unless (= steps 0) (format t "---Step ~A---~%" i))
      (dolist (vdef vdefs nil)
	(if (eq (second vdef) 'mem)
	    (let ((v-alist (aref (cdr (assoc (first vdef) mems :test 'eq)) i)))
	      ;; (format t "v-alist: ~A~%" v-alist)
	      (dolist (pr v-alist)
		(format t "  ~A word ~A = ~A~%"
			(first vdef)
			(car pr)
			(cdr pr))))
	  (let* ((key (car vdef))
		 (val (gethash key vhash)))
	    (format t "  ~A = 0b" key)
	    (let ((ad (array-dimension val 1)))
	      (dotimes (j ad (format t "~%"))
		(format t "~A" (aref val i (1- (- ad j))))))))))))
